/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;

public class ShulkerFillLevelAttribute
implements ItemAttribute {
    public static final ShulkerFillLevelAttribute EMPTY = new ShulkerFillLevelAttribute(null);
    private final ShulkerLevels levels;

    public ShulkerFillLevelAttribute(ShulkerLevels levels) {
        this.levels = levels;
    }

    @Override
    public boolean appliesTo(ItemStack stack) {
        return this.levels != null && this.levels.canApply(stack);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack stack) {
        return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.canApply(stack)).map(ShulkerFillLevelAttribute::new).collect(Collectors.toList());
    }

    @Override
    public String getTranslationKey() {
        return "shulker_level";
    }

    @Override
    public Object[] getTranslationParameters() {
        String parameter = "";
        if (this.levels != null) {
            parameter = Lang.translate("item_attributes." + this.getTranslationKey() + "." + this.levels.key, new Object[0]).getString();
        }
        return new Object[]{parameter};
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        if (this.levels != null) {
            nbt.func_74778_a("id", this.levels.key);
        }
    }

    @Override
    public ItemAttribute readNBT(CompoundNBT nbt) {
        return nbt.func_74764_b("id") ? new ShulkerFillLevelAttribute(ShulkerLevels.fromKey(nbt.func_74779_i("id"))) : EMPTY;
    }

    static enum ShulkerLevels {
        EMPTY("empty", amount -> amount == 0),
        PARTIAL("partial", amount -> amount > 0 && amount < Integer.MAX_VALUE),
        FULL("full", amount -> amount == Integer.MAX_VALUE);

        private final Predicate<Integer> requiredSize;
        private final String key;

        private ShulkerLevels(String key, Predicate<Integer> requiredSize) {
            this.key = key;
            this.requiredSize = requiredSize;
        }

        @Nullable
        public static ShulkerLevels fromKey(String key) {
            return Arrays.stream(ShulkerLevels.values()).filter(shulkerLevels -> shulkerLevels.key.equals(key)).findFirst().orElse(null);
        }

        private static boolean isShulker(ItemStack stack) {
            return Block.func_149634_a((Item)stack.func_77973_b()) instanceof ShulkerBoxBlock;
        }

        public boolean canApply(ItemStack testStack) {
            if (!ShulkerLevels.isShulker(testStack)) {
                return false;
            }
            CompoundNBT compoundnbt = testStack.func_179543_a("BlockEntityTag");
            if (compoundnbt == null) {
                return this.requiredSize.test(0);
            }
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                return false;
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                int rawSize = compoundnbt.func_150295_c("Items", 10).size();
                if (rawSize < 27) {
                    return this.requiredSize.test(rawSize);
                }
                NonNullList inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)inventory);
                boolean isFull = inventory.stream().allMatch(itemStack -> !itemStack.func_190926_b() && itemStack.func_190916_E() == itemStack.func_77976_d());
                return this.requiredSize.test(isFull ? Integer.MAX_VALUE : rawSize);
            }
            return this.requiredSize.test(0);
        }
    }
}

