/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.chute.ChuteShapes;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractChuteBlock
extends Block
implements IWrenchable,
ITE<ChuteTileEntity> {
    public AbstractChuteBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public static boolean isChute(BlockState state) {
        return state.func_177230_c() instanceof AbstractChuteBlock;
    }

    public static boolean isOpenChute(BlockState state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.func_177230_c()).isOpen(state);
    }

    public static boolean isTransparentChute(BlockState state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.func_177230_c()).isTransparent(state);
    }

    @Nullable
    public static Direction getChuteFacing(BlockState state) {
        return !AbstractChuteBlock.isChute(state) ? null : ((AbstractChuteBlock)state.func_177230_c()).getFacing(state);
    }

    public Direction getFacing(BlockState state) {
        return Direction.DOWN;
    }

    public boolean isOpen(BlockState state) {
        return true;
    }

    public boolean isTransparent(BlockState state) {
        return false;
    }

    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        super.func_176216_a(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.field_70170_p.field_72995_K) {
            return;
        }
        if (!entityIn.func_70089_S()) {
            return;
        }
        DirectBeltInputBehaviour input = TileEntityBehaviour.get((IBlockReader)entityIn.field_70170_p, new BlockPos(entityIn.func_213303_ch().func_72441_c(0.0, 0.5, 0.0)).func_177977_b(), DirectBeltInputBehaviour.TYPE);
        if (input == null) {
            return;
        }
        if (!input.canInsertFromSide(Direction.UP)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        ItemStack toInsert = itemEntity.func_92059_d();
        ItemStack remainder = input.handleInsertion(toInsert, Direction.UP, false);
        if (remainder.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        if (remainder.func_190916_E() < toInsert.func_190916_E()) {
            itemEntity.func_92058_a(remainder);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        this.withTileEntityDo((IBlockReader)world, pos, ChuteTileEntity::onAdded);
        if (p_220082_5_) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
    }

    protected void updateDiagonalNeighbour(BlockState state, World world, BlockPos pos) {
        BlockState updated;
        BlockState stateToUpdate;
        if (!AbstractChuteBlock.isChute(state)) {
            return;
        }
        AbstractChuteBlock block = (AbstractChuteBlock)state.func_177230_c();
        Direction facing = block.getFacing(state);
        BlockPos toUpdate = pos.func_177977_b();
        if (facing.func_176740_k().func_176722_c()) {
            toUpdate = toUpdate.func_177972_a(facing.func_176734_d());
        }
        if ((stateToUpdate = world.func_180495_p(toUpdate)) != (updated = this.updateChuteState(stateToUpdate, world.func_180495_p(toUpdate.func_177984_a()), (IBlockReader)world, toUpdate)) && !world.field_72995_K) {
            world.func_175656_a(toUpdate, updated);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
        boolean differentBlock;
        boolean bl = differentBlock = state.func_177230_c() != p_196243_4_.func_177230_c();
        if (state.hasTileEntity() && (differentBlock || !p_196243_4_.hasTileEntity())) {
            TileEntityBehaviour.destroy((IBlockReader)world, pos, FilteringBehaviour.TYPE);
            this.withTileEntityDo((IBlockReader)world, pos, c -> c.onRemoved(state));
            world.func_175713_t(pos);
        }
        if (p_196243_5_ || !differentBlock) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
        for (Direction direction : Iterate.horizontalDirections) {
            BlockState updated;
            BlockPos toUpdate = pos.func_177984_a().func_177972_a(direction);
            BlockState stateToUpdate = world.func_180495_p(toUpdate);
            if (!AbstractChuteBlock.isChute(stateToUpdate) || stateToUpdate == (updated = ((AbstractChuteBlock)stateToUpdate.func_177230_c()).updateChuteState(stateToUpdate, world.func_180495_p(toUpdate.func_177984_a()), (IBlockReader)world, toUpdate)) || world.field_72995_K) continue;
            world.func_175656_a(toUpdate, updated);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState above, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (direction != Direction.UP) {
            return state;
        }
        return this.updateChuteState(state, above, (IBlockReader)world, pos);
    }

    public void func_220069_a(BlockState p_220069_1_, World world, BlockPos pos, Block p_220069_4_, BlockPos neighbourPos, boolean p_220069_6_) {
        if (pos.func_177977_b().equals((Object)neighbourPos)) {
            this.withTileEntityDo((IBlockReader)world, pos, ChuteTileEntity::blockBelowChanged);
        } else if (pos.func_177984_a().equals((Object)neighbourPos)) {
            this.withTileEntityDo((IBlockReader)world, pos, chute -> {
                chute.capAbove = LazyOptional.empty();
            });
        }
    }

    public abstract BlockState updateChuteState(BlockState var1, BlockState var2, IBlockReader var3, BlockPos var4);

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        BlockHelper.addReducedDestroyEffects(state, world, pos, manager);
        return true;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return ChuteShapes.getShape(p_220053_1_);
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return ChuteShapes.getCollisionShape(p_220071_1_);
    }

    @Override
    public Class<ChuteTileEntity> getTileEntityClass() {
        return ChuteTileEntity.class;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
        if (!player.func_184586_b(hand).func_190926_b()) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        return this.onTileEntityUse((IBlockReader)world, pos, te -> {
            if (te.item.func_190926_b()) {
                return ActionResultType.PASS;
            }
            player.field_71071_by.func_191975_a(world, te.item);
            te.setItem(ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        });
    }
}

