/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.simibubi.create.content.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class DynamicBrush
extends Brush {
    public static final int MAX_RADIUS = 10;
    private boolean surface;

    public DynamicBrush(boolean surface) {
        super(1);
        this.surface = surface;
    }

    @Override
    ITextComponent getParamLabel(int paramIndex) {
        return Lang.translate("generic.range", new Object[0]);
    }

    @Override
    public TerrainTools[] getSupportedTools() {
        TerrainTools[] terrainToolsArray;
        if (this.surface) {
            TerrainTools[] terrainToolsArray2 = new TerrainTools[3];
            terrainToolsArray2[0] = TerrainTools.Overlay;
            terrainToolsArray2[1] = TerrainTools.Replace;
            terrainToolsArray = terrainToolsArray2;
            terrainToolsArray2[2] = TerrainTools.Clear;
        } else {
            TerrainTools[] terrainToolsArray3 = new TerrainTools[2];
            terrainToolsArray3[0] = TerrainTools.Replace;
            terrainToolsArray = terrainToolsArray3;
            terrainToolsArray3[1] = TerrainTools.Clear;
        }
        return terrainToolsArray;
    }

    @Override
    public boolean hasPlacementOptions() {
        return false;
    }

    @Override
    public boolean hasConnectivityOptions() {
        return true;
    }

    @Override
    int getMax(int paramIndex) {
        return 10;
    }

    @Override
    int getMin(int paramIndex) {
        return 1;
    }

    @Override
    public TerrainTools redirectTool(TerrainTools tool) {
        if (tool == TerrainTools.Overlay) {
            return TerrainTools.Place;
        }
        return super.redirectTool(tool);
    }

    @Override
    public Collection<BlockPos> addToGlobalPositions(IWorld world, BlockPos targetPos, Direction targetFace, Collection<BlockPos> affectedPositions, TerrainTools usedTool) {
        boolean searchDiagonals = this.param1 == 0;
        boolean fuzzy = this.param2 == 0;
        boolean replace = usedTool != TerrainTools.Overlay;
        int searchRange = this.param0;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        BlockState state = world.func_180495_p(targetPos);
        LinkedList<BlockPos> offsets = new LinkedList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) >= 2 && !searchDiagonals || targetFace.func_176740_k().func_196052_a(x, y, z) != 0 && this.surface) continue;
                    offsets.add(new BlockPos(x, y, z));
                }
            }
        }
        BlockPos startPos = replace ? targetPos : targetPos.func_177972_a(targetFace);
        frontier.add(startPos);
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            if (!currentPos.func_218141_a((Vector3i)startPos, (double)searchRange)) continue;
            if (replace) {
                BlockState stateToReplace = world.func_180495_p(currentPos);
                BlockState stateAboveStateToReplace = world.func_180495_p(currentPos.func_177972_a(targetFace));
                if (stateToReplace.func_185887_b((IBlockReader)world, currentPos) == -1.0f || stateToReplace.func_177230_c() != state.func_177230_c() && !fuzzy || stateToReplace.func_185904_a().func_76222_j() || BlockHelper.hasBlockSolidSide(stateAboveStateToReplace, (IBlockReader)world, currentPos.func_177972_a(targetFace), targetFace.func_176734_d()) && this.surface) continue;
                affectedPositions.add(currentPos);
                for (BlockPos offset : offsets) {
                    frontier.add(currentPos.func_177971_a((Vector3i)offset));
                }
                continue;
            }
            BlockState stateToPlaceAt = world.func_180495_p(currentPos);
            BlockState stateToPlaceOn = world.func_180495_p(currentPos.func_177972_a(targetFace.func_176734_d()));
            if (stateToPlaceOn.func_185904_a().func_76222_j() || stateToPlaceOn.func_177230_c() != state.func_177230_c() && !fuzzy || !stateToPlaceAt.func_185904_a().func_76222_j()) continue;
            affectedPositions.add(currentPos);
            for (BlockPos offset : offsets) {
                frontier.add(currentPos.func_177971_a((Vector3i)offset));
            }
        }
        return affectedPositions;
    }
}

