/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.belt.transport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.belt.transport.BeltInventory;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltTunnelInteractionHandler {
    public static boolean flapTunnelsAndCheckIfStuck(BeltInventory beltInventory, TransportedItemStack current, float nextOffset) {
        int currentSegment = (int)current.beltPosition;
        int upcomingSegment = (int)nextOffset;
        Direction movementFacing = beltInventory.belt.getMovementFacing();
        if (!beltInventory.beltMovementPositive && nextOffset == 0.0f) {
            upcomingSegment = -1;
        }
        if (currentSegment == upcomingSegment) {
            return false;
        }
        if (BeltTunnelInteractionHandler.stuckAtTunnel(beltInventory, upcomingSegment, current.stack, movementFacing)) {
            current.beltPosition = (float)currentSegment + (beltInventory.beltMovementPositive ? 0.99f : 0.01f);
            return true;
        }
        World world = beltInventory.belt.func_145831_w();
        boolean onServer = !world.field_72995_K || beltInventory.belt.isVirtual();
        boolean removed = false;
        BeltTunnelTileEntity nextTunnel = BeltTunnelInteractionHandler.getTunnelOnSegment(beltInventory, upcomingSegment);
        if (nextTunnel instanceof BrassTunnelTileEntity) {
            BrassTunnelTileEntity brassTunnel = (BrassTunnelTileEntity)nextTunnel;
            if (brassTunnel.hasDistributionBehaviour()) {
                if (!brassTunnel.canTakeItems()) {
                    return true;
                }
                if (onServer) {
                    brassTunnel.setStackToDistribute(current.stack);
                    current.stack = ItemStack.field_190927_a;
                    beltInventory.belt.sendData();
                    beltInventory.belt.func_70296_d();
                }
                removed = true;
            }
        } else if (nextTunnel != null) {
            BlockState blockState = nextTunnel.func_195044_w();
            if (current.stack.func_190916_E() > 1 && AllBlocks.ANDESITE_TUNNEL.has(blockState) && BeltTunnelBlock.isJunction(blockState) && movementFacing.func_176740_k() == blockState.func_177229_b(BeltTunnelBlock.HORIZONTAL_AXIS)) {
                for (Direction d : Iterate.horizontalDirections) {
                    if (d.func_176740_k() == blockState.func_177229_b(BeltTunnelBlock.HORIZONTAL_AXIS) || !nextTunnel.flaps.containsKey(d)) continue;
                    BlockPos outpos = nextTunnel.func_174877_v().func_177977_b().func_177972_a(d);
                    if (!world.func_195588_v(outpos)) {
                        return true;
                    }
                    DirectBeltInputBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, outpos, DirectBeltInputBehaviour.TYPE);
                    if (behaviour == null || !behaviour.canInsertFromSide(d)) continue;
                    ItemStack toinsert = ItemHandlerHelper.copyStackWithSize((ItemStack)current.stack, (int)1);
                    if (!behaviour.handleInsertion(toinsert, d, false).func_190926_b()) {
                        return true;
                    }
                    if (onServer) {
                        BeltTunnelInteractionHandler.flapTunnel(beltInventory, upcomingSegment, d, false);
                    }
                    current.stack.func_190918_g(1);
                    beltInventory.belt.sendData();
                    if (current.stack.func_190916_E() <= 1) break;
                }
            }
        }
        if (onServer) {
            BeltTunnelInteractionHandler.flapTunnel(beltInventory, currentSegment, movementFacing, false);
            BeltTunnelInteractionHandler.flapTunnel(beltInventory, upcomingSegment, movementFacing.func_176734_d(), true);
        }
        return removed;
    }

    public static boolean stuckAtTunnel(BeltInventory beltInventory, int offset, ItemStack stack, Direction movementDirection) {
        BeltTileEntity belt = beltInventory.belt;
        BlockPos pos = BeltHelper.getPositionForOffset(belt, offset).func_177984_a();
        if (!(belt.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BrassTunnelBlock)) {
            return false;
        }
        TileEntity te = belt.func_145831_w().func_175625_s(pos);
        if (te == null || !(te instanceof BrassTunnelTileEntity)) {
            return false;
        }
        BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)te;
        return !tunnel.canInsert(movementDirection.func_176734_d(), stack);
    }

    public static void flapTunnel(BeltInventory beltInventory, int offset, Direction side, boolean inward) {
        BeltTunnelTileEntity te = BeltTunnelInteractionHandler.getTunnelOnSegment(beltInventory, offset);
        if (te == null) {
            return;
        }
        te.flap(side, inward);
    }

    protected static BeltTunnelTileEntity getTunnelOnSegment(BeltInventory beltInventory, int offset) {
        BeltTileEntity belt = beltInventory.belt;
        if (belt.func_195044_w().func_177229_b(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL) {
            return null;
        }
        return BeltTunnelInteractionHandler.getTunnelOnPosition(belt.func_145831_w(), BeltHelper.getPositionForOffset(belt, offset));
    }

    public static BeltTunnelTileEntity getTunnelOnPosition(World world, BlockPos pos) {
        if (!(world.func_180495_p(pos = pos.func_177984_a()).func_177230_c() instanceof BeltTunnelBlock)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof BeltTunnelTileEntity)) {
            return null;
        }
        return (BeltTunnelTileEntity)te;
    }
}

