/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced.sequencer;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.InstructionSpeedModifiers;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.OnIsPoweredResult;
import com.simibubi.create.content.contraptions.relays.advanced.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Vector;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;

public class Instruction {
    SequencerInstructions instruction;
    InstructionSpeedModifiers speedModifier;
    int value;

    public Instruction(SequencerInstructions instruction) {
        this(instruction, 1);
    }

    public Instruction(SequencerInstructions instruction, int value) {
        this.instruction = instruction;
        this.speedModifier = InstructionSpeedModifiers.FORWARD;
        this.value = value;
    }

    int getDuration(float currentProgress, float speed) {
        speed *= (float)this.speedModifier.value;
        speed = Math.abs(speed);
        double target = (float)this.value - currentProgress;
        switch (this.instruction) {
            case TURN_ANGLE: {
                double degreesPerTick = KineticTileEntity.convertToAngular(speed);
                int ticks = (int)(target / degreesPerTick);
                double degreesErr = target - degreesPerTick * (double)ticks;
                return ticks + (degreesPerTick > 2.0 * degreesErr ? 0 : 1);
            }
            case TURN_DISTANCE: {
                double metersPerTick = KineticTileEntity.convertToLinear(speed);
                int offset = speed > 0.0f && this.speedModifier.value < 0 ? 1 : 2;
                return (int)(target / metersPerTick + (double)offset);
            }
            case DELAY: {
                return (int)target;
            }
            case AWAIT: {
                return -1;
            }
        }
        return 0;
    }

    float getTickProgress(float speed) {
        switch (this.instruction) {
            case TURN_ANGLE: {
                return KineticTileEntity.convertToAngular(speed);
            }
            case TURN_DISTANCE: {
                return KineticTileEntity.convertToLinear(speed);
            }
            case DELAY: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    int getSpeedModifier() {
        switch (this.instruction) {
            case TURN_ANGLE: 
            case TURN_DISTANCE: {
                return this.speedModifier.value;
            }
        }
        return 0;
    }

    OnIsPoweredResult onRedstonePulse() {
        return this.instruction == SequencerInstructions.AWAIT ? OnIsPoweredResult.CONTINUE : OnIsPoweredResult.NOTHING;
    }

    public static ListNBT serializeAll(Vector<Instruction> instructions) {
        ListNBT list = new ListNBT();
        instructions.forEach(i -> list.add((Object)i.serialize()));
        return list;
    }

    public static Vector<Instruction> deserializeAll(ListNBT list) {
        if (list.isEmpty()) {
            return Instruction.createDefault();
        }
        Vector<Instruction> instructions = new Vector<Instruction>(5);
        list.forEach(inbt -> instructions.add(Instruction.deserialize((CompoundNBT)inbt)));
        return instructions;
    }

    public static Vector<Instruction> createDefault() {
        Vector<Instruction> instructions = new Vector<Instruction>(5);
        instructions.add(new Instruction(SequencerInstructions.TURN_ANGLE, 90));
        instructions.add(new Instruction(SequencerInstructions.END));
        return instructions;
    }

    CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        NBTHelper.writeEnum(tag, "Type", this.instruction);
        NBTHelper.writeEnum(tag, "Modifier", this.speedModifier);
        tag.func_74768_a("Value", this.value);
        return tag;
    }

    static Instruction deserialize(CompoundNBT tag) {
        Instruction instruction = new Instruction(NBTHelper.readEnum(tag, "Type", SequencerInstructions.class));
        instruction.speedModifier = NBTHelper.readEnum(tag, "Modifier", InstructionSpeedModifiers.class);
        instruction.value = tag.func_74762_e("Value");
        return instruction;
    }
}

