/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.goggles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CClient;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GoggleOverlayRenderer {
    private static final List<Supplier<Boolean>> customGogglePredicates = new LinkedList<Supplier<Boolean>>();
    private static final Map<Object, Outliner.OutlineEntry> outlines = CreateClient.OUTLINER.getOutlines();
    public static int hoverTicks = 0;
    public static BlockPos lastHovered = null;

    public static void renderOverlay(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, float partialTicks) {
        Color colorBorderBot;
        boolean exceptionAdded;
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        ItemStack headSlot = mc.field_71439_g.func_184582_a(EquipmentSlotType.HEAD);
        TileEntity te = world.func_175625_s(pos);
        hoverTicks = lastHovered == null || lastHovered.equals((Object)pos) ? ++hoverTicks : 0;
        lastHovered = pos;
        boolean wearingGoggles = AllItems.GOGGLES.isIn(headSlot);
        for (Supplier<Boolean> supplier : customGogglePredicates) {
            wearingGoggles |= supplier.get().booleanValue();
        }
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, mc.field_71439_g.func_225608_bj_());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, mc.field_71439_g.func_225608_bj_());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (te instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)te).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if (wearingGoggles && AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            Direction[] directions = Iterate.directionsInAxis(((Direction)state.func_177229_b((Property)PistonExtensionPoleBlock.field_176387_N)).func_176740_k());
            int poles = 1;
            boolean pistonFound = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((World)world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.func_180495_p(pos.func_177967_a(dir, attachedPoles + 1)).func_177230_c() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(StringTextComponent.field_240750_d_);
            }
            tooltip.add((ITextComponent)IHaveGoggleInformation.componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("gui.goggles.pole_length", new Object[0])).func_230529_a_((ITextComponent)new StringTextComponent(" " + poles)));
        }
        if (tooltip.isEmpty()) {
            return;
        }
        ms.func_227860_a_();
        TooltipScreen tooltipScreen = new TooltipScreen(null);
        tooltipScreen.func_231158_b_(mc, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
        int titleLinesCount = 1;
        int tooltipTextWidth = 0;
        for (ITextProperties iTextProperties : tooltip) {
            int textLineWidth = mc.field_71466_p.func_238414_a_(iTextProperties);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += (tooltip.size() - 1) * 10;
            if (tooltip.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        CClient cClient = AllConfigs.CLIENT;
        int posX = tooltipScreen.field_230708_k_ / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = tooltipScreen.field_230709_l_ / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, tooltipScreen.field_230708_k_ - tooltipTextWidth - 20);
        posY = Math.min(posY, tooltipScreen.field_230709_l_ - tooltipHeight - 20);
        float fade = MathHelper.func_76131_a((float)(((float)hoverTicks + partialTicks) / 12.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color((Integer)cClient.overlayBackgroundColor.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BACKGROUND).scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color((Integer)cClient.overlayBorderColorTop.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, true).copy();
        Color color = colorBorderBot = useCustom != false ? new Color((Integer)cClient.overlayBorderColorBot.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, false).copy();
        if (fade < 1.0f) {
            ms.func_227861_a_((double)((1.0f - fade) * Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 4.0f), 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        GuiUtils.drawHoveringText((MatrixStack)ms, tooltip, (int)posX, (int)posY, (int)tooltipScreen.field_230708_k_, (int)tooltipScreen.field_230709_l_, (int)-1, (int)colorBackground.getRGB(), (int)colorBorderTop.getRGB(), (int)colorBorderBot.getRGB(), (FontRenderer)mc.field_71466_p);
        ItemStack item = AllItems.GOGGLES.asStack();
        ((RenderElement)GuiGameElement.of(item).at(posX + 10, posY - 16, 450.0f)).render(ms);
        ms.func_227865_b_();
    }

    public static void registerCustomGoggleCondition(Supplier<Boolean> condition) {
        customGogglePredicates.add(condition);
    }

    public static final class TooltipScreen
    extends Screen {
        public TooltipScreen(ITextComponent p_i51108_1_) {
            super(p_i51108_1_);
        }

        public void func_231158_b_(Minecraft mc, int width, int height) {
            this.field_230706_i_ = mc;
            this.field_230707_j_ = mc.func_175599_af();
            this.field_230712_o_ = mc.field_71466_p;
            this.field_230708_k_ = width;
            this.field_230709_l_ = height;
        }
    }
}

