/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.GlueEffectPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueItem;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.worldWrappers.RayTraceWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class SuperGlueHandler {
    public static Map<Direction, SuperGlueEntity> gatherGlue(IWorld world, BlockPos pos) {
        List entities = world.func_217357_a(SuperGlueEntity.class, new AxisAlignedBB(pos));
        HashMap<Direction, SuperGlueEntity> map = new HashMap<Direction, SuperGlueEntity>();
        for (SuperGlueEntity entity : entities) {
            map.put(entity.getAttachedDirection(pos), entity);
        }
        return map;
    }

    @SubscribeEvent
    public static void glueListensForBlockPlacement(BlockEvent.EntityPlaceEvent event) {
        IWorld world = event.getWorld();
        Entity entity = event.getEntity();
        BlockPos pos = event.getPos();
        if (entity == null || world == null || pos == null) {
            return;
        }
        if (world.func_201670_d()) {
            return;
        }
        Map<Direction, SuperGlueEntity> gatheredGlue = SuperGlueHandler.gatherGlue(world, pos);
        for (Direction direction : gatheredGlue.keySet()) {
            AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new GlueEffectPacket(pos, direction, true));
        }
        if (entity instanceof PlayerEntity) {
            SuperGlueHandler.glueInOffHandAppliesOnBlockPlace(event, pos, (PlayerEntity)entity);
        }
    }

    public static void glueInOffHandAppliesOnBlockPlace(BlockEvent.EntityPlaceEvent event, BlockPos pos, PlayerEntity placer) {
        ItemStack itemstack = placer.func_184592_cb();
        ModifiableAttributeInstance reachAttribute = placer.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (!AllItems.SUPER_GLUE.isIn(itemstack) || reachAttribute == null) {
            return;
        }
        if (AllItems.WRENCH.isIn(placer.func_184614_ca())) {
            return;
        }
        if (event.getPlacedAgainst() == IPlacementHelper.ID) {
            return;
        }
        double distance = reachAttribute.func_111126_e();
        Vector3d start = placer.func_174824_e(1.0f);
        Vector3d look = placer.func_70676_i(1.0f);
        World world = placer.field_70170_p;
        RayTraceWorld rayTraceWorld = new RayTraceWorld((IWorld)world, (p, state) -> p.equals((Object)pos) ? Blocks.field_150350_a.func_176223_P() : state);
        Vector3d end = start.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        BlockRayTraceResult ray = rayTraceWorld.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)placer));
        Direction face = ray.func_216354_b();
        if (face == null || ray.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        if (!ray.func_216350_a().func_177972_a(face).equals((Object)pos)) {
            event.setCanceled(true);
            return;
        }
        SuperGlueEntity entity = new SuperGlueEntity(world, ray.func_216350_a(), face.func_176734_d());
        CompoundNBT compoundnbt = itemstack.func_77978_p();
        if (compoundnbt != null) {
            EntityType.func_208048_a((World)world, (PlayerEntity)placer, (Entity)entity, (CompoundNBT)compoundnbt);
        }
        if (entity.onValidSurface()) {
            if (!world.field_72995_K) {
                entity.playPlaceSound();
                world.func_217376_c((Entity)entity);
                AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new GlueEffectPacket(ray.func_216350_a(), face, true));
            }
            itemstack.func_222118_a(1, (LivingEntity)placer, SuperGlueItem::onBroken);
        }
    }
}

