/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileInstance;
import com.simibubi.create.content.contraptions.base.RotatingData;
import com.simibubi.create.content.contraptions.components.fan.EncasedFanTileEntity;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class FanInstance
extends KineticTileInstance<EncasedFanTileEntity> {
    protected final RotatingData shaft;
    protected final RotatingData fan;
    final Direction direction;
    private final Direction opposite;

    public FanInstance(MaterialManager<?> modelManager, EncasedFanTileEntity tile) {
        super(modelManager, tile);
        this.direction = (Direction)this.blockState.func_177229_b((Property)BlockStateProperties.field_208155_H);
        this.opposite = this.direction.func_176734_d();
        this.shaft = (RotatingData)this.getRotatingMaterial().getModel(AllBlockPartials.SHAFT_HALF, this.blockState, this.opposite).createInstance();
        this.fan = (RotatingData)modelManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(AllBlockPartials.ENCASED_FAN_INNER, this.blockState, this.opposite).createInstance();
        this.setup(this.shaft);
        this.setup(this.fan, this.getFanSpeed());
    }

    private float getFanSpeed() {
        float speed = ((EncasedFanTileEntity)this.tile).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = MathHelper.func_76131_a((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = MathHelper.func_76131_a((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    public void update() {
        this.updateRotation(this.shaft);
        this.updateRotation(this.fan, this.getFanSpeed());
    }

    public void updateLight() {
        BlockPos behind = this.pos.func_177972_a(this.opposite);
        this.relight(behind, new IFlatLight[]{this.shaft});
        BlockPos inFront = this.pos.func_177972_a(this.direction);
        this.relight(inFront, new IFlatLight[]{this.fan});
    }

    public void remove() {
        this.shaft.delete();
        this.fan.delete();
    }
}

