/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DeployerRecipeSearchEvent
extends Event {
    private final DeployerTileEntity tileEntity;
    private final RecipeWrapper inventory;
    @Nullable
    IRecipe<? extends IInventory> recipe = null;
    private int maxPriority = 0;

    public DeployerRecipeSearchEvent(DeployerTileEntity tileEntity, RecipeWrapper inventory) {
        this.tileEntity = tileEntity;
        this.inventory = inventory;
    }

    public boolean isCancelable() {
        return true;
    }

    public DeployerTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public RecipeWrapper getInventory() {
        return this.inventory;
    }

    public boolean shouldAddRecipeWithPriority(int priority) {
        return !this.isCanceled() && priority > this.maxPriority;
    }

    @Nullable
    public IRecipe<? extends IInventory> getRecipe() {
        if (this.isCanceled()) {
            return null;
        }
        return this.recipe;
    }

    public void addRecipe(Supplier<Optional<? extends IRecipe<? extends IInventory>>> recipeSupplier, int priority) {
        if (!this.shouldAddRecipeWithPriority(priority)) {
            return;
        }
        recipeSupplier.get().ifPresent(newRecipe -> {
            this.recipe = newRecipe;
            this.maxPriority = priority;
        });
    }
}

