/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.gui;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.client.CitadelPatreonRenderer;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.SettingsScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class GuiCitadelPatreonConfig
extends SettingsScreen {
    private Slider distSlider;
    private Slider speedSlider;
    private Slider heightSlider;
    private Button changeButton;
    private final Slider.ISlider distSliderResponder;
    private final Slider.ISlider speedSliderResponder;
    private final Slider.ISlider heightSliderResponder;
    private float rotateDist;
    private float rotateSpeed;
    private float rotateHeight;
    private String followType = "citadel";

    public GuiCitadelPatreonConfig(Screen parentScreenIn, GameSettings gameSettingsIn) {
        super(parentScreenIn, gameSettingsIn, (ITextComponent)new TranslationTextComponent("citadel.gui.patreon_customization"));
        CompoundNBT tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        float distance = tag.func_74764_b("CitadelRotateDistance") ? tag.func_74760_g("CitadelRotateDistance") : 2.0f;
        float speed = tag.func_74764_b("CitadelRotateSpeed") ? tag.func_74760_g("CitadelRotateSpeed") : 1.0f;
        float height = tag.func_74764_b("CitadelRotateHeight") ? tag.func_74760_g("CitadelRotateHeight") : 1.0f;
        this.rotateDist = GuiCitadelPatreonConfig.roundTo(distance, 3);
        this.rotateSpeed = GuiCitadelPatreonConfig.roundTo(speed, 3);
        this.rotateHeight = GuiCitadelPatreonConfig.roundTo(height, 3);
        this.followType = tag.func_74764_b("CitadelFollowerType") ? tag.func_74779_i("CitadelFollowerType") : "citadel";
        this.distSliderResponder = new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiCitadelPatreonConfig.this.setSliderValue(0, (float)slider.sliderValue);
            }
        };
        this.speedSliderResponder = new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiCitadelPatreonConfig.this.setSliderValue(1, (float)slider.sliderValue);
            }
        };
        this.heightSliderResponder = new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiCitadelPatreonConfig.this.setSliderValue(2, (float)slider.sliderValue);
            }
        };
    }

    private void setSliderValue(int i, float sliderValue) {
        boolean flag = false;
        CompoundNBT tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        if (i == 0) {
            this.rotateDist = GuiCitadelPatreonConfig.roundTo(sliderValue * 5.0f, 3);
            tag.func_74776_a("CitadelRotateDistance", this.rotateDist);
            this.distSlider.dragging = false;
        } else if (i == 1) {
            this.rotateSpeed = GuiCitadelPatreonConfig.roundTo(sliderValue * 5.0f, 3);
            tag.func_74776_a("CitadelRotateSpeed", this.rotateSpeed);
            this.speedSlider.dragging = false;
        } else {
            this.rotateHeight = GuiCitadelPatreonConfig.roundTo(sliderValue * 2.0f, 3);
            tag.func_74776_a("CitadelRotateHeight", this.rotateHeight);
            this.heightSlider.dragging = false;
        }
        CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g, tag);
        Citadel.sendMSGToServer(new PropertiesMessage("CitadelPatreonConfig", tag, Minecraft.func_71410_x().field_71439_g.func_145782_y()));
    }

    public static float roundTo(float value, int places) {
        return value;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        GuiCitadelPatreonConfig.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int i = this.field_230708_k_ / 2;
        int j = this.field_230709_l_ / 6;
        this.func_230480_a_((Widget)new Button(i - 100, j + 120, 200, 20, DialogTexts.field_240632_c_, p_213079_1_ -> this.field_230706_i_.func_147108_a(this.field_228182_a_)));
        this.distSlider = new Slider(i - 75 - 25, j + 30, 150, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.orbit_dist").func_230529_a_((ITextComponent)new StringTextComponent(": ")), (ITextComponent)new StringTextComponent(""), 0.125, 5.0, this.rotateDist, true, true, p_214132_1_ -> {}, this.distSliderResponder){};
        this.func_230480_a_((Widget)this.distSlider);
        this.func_230480_a_((Widget)new Button(i - 75 + 135, j + 30, 40, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.reset"), p_213079_1_ -> {
            this.setSliderValue(0, 0.4f);
            this.distSlider.sliderValue = 0.4f;
            this.distSlider.updateSlider();
        }));
        this.speedSlider = new Slider(i - 75 - 25, j + 60, 150, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.orbit_speed").func_230529_a_((ITextComponent)new StringTextComponent(": ")), (ITextComponent)new StringTextComponent(""), 0.0, 5.0, this.rotateSpeed, true, true, p_214132_1_ -> {}, this.speedSliderResponder){};
        this.func_230480_a_((Widget)this.speedSlider);
        this.func_230480_a_((Widget)new Button(i - 75 + 135, j + 60, 40, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.reset"), p_213079_1_ -> {
            this.setSliderValue(1, 0.2f);
            this.speedSlider.sliderValue = 0.2f;
            this.speedSlider.updateSlider();
        }));
        this.heightSlider = new Slider(i - 75 - 25, j + 90, 150, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.orbit_height").func_230529_a_((ITextComponent)new StringTextComponent(": ")), (ITextComponent)new StringTextComponent(""), 0.0, 2.0, this.rotateHeight, true, true, p_214132_1_ -> {}, this.heightSliderResponder){};
        this.func_230480_a_((Widget)this.heightSlider);
        this.func_230480_a_((Widget)new Button(i - 75 + 135, j + 90, 40, 20, (ITextComponent)new TranslationTextComponent("citadel.gui.reset"), p_213079_1_ -> {
            this.setSliderValue(2, 0.5f);
            this.heightSlider.sliderValue = 0.5;
            this.heightSlider.updateSlider();
        }));
        this.distSlider.precision = 1;
        this.heightSlider.precision = 2;
        this.speedSlider.precision = 2;
        this.distSlider.updateSlider();
        this.heightSlider.updateSlider();
        this.speedSlider.updateSlider();
        this.changeButton = new Button(i - 100, j, 200, 20, this.getTypeText(), p_213079_1_ -> {
            this.followType = CitadelPatreonRenderer.getIdOfNext(this.followType);
            CompoundNBT tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g);
            if (tag != null) {
                tag.func_74778_a("CitadelFollowerType", this.followType);
                CitadelEntityData.setCitadelTag((LivingEntity)Minecraft.func_71410_x().field_71439_g, tag);
            }
            Citadel.sendMSGToServer(new PropertiesMessage("CitadelPatreonConfig", tag, Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            this.changeButton.func_238482_a_(this.getTypeText());
        });
        this.func_230480_a_((Widget)this.changeButton);
    }

    private ITextComponent getTypeText() {
        return new TranslationTextComponent("citadel.gui.follower_type").func_230529_a_((ITextComponent)new TranslationTextComponent("citadel.follower." + this.followType));
    }
}

