/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import java.util.List;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ChunkRenderDispatcher.CompiledChunk.class})
public class CancelTileEntityRenderMixin {
    @Inject(at={@At(value="RETURN")}, method={"getRenderableBlockEntities"}, cancellable=true)
    private void noRenderInstancedTiles(CallbackInfoReturnable<List<TileEntity>> cir) {
        if (Backend.getInstance().canUseInstancing()) {
            List tiles = (List)cir.getReturnValue();
            InstancedRenderRegistry r = InstancedRenderRegistry.getInstance();
            tiles.removeIf(r::shouldSkipRender);
        }
    }
}

