/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.instancing;

import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ConditionalInstance<D extends InstanceData> {
    final Instancer<D> model;
    ICondition condition;
    Consumer<D> setupFunc;
    @Nullable
    private D instance;

    public ConditionalInstance(Instancer<D> model) {
        this.model = model;
        this.condition = () -> true;
    }

    public ConditionalInstance<D> withSetupFunc(Consumer<D> setupFunc) {
        this.setupFunc = setupFunc;
        return this;
    }

    public ConditionalInstance<D> withCondition(ICondition condition) {
        this.condition = condition;
        return this;
    }

    public ConditionalInstance<D> update() {
        boolean shouldShow = this.condition.shouldShow();
        if (shouldShow && this.instance == null) {
            this.instance = this.model.createInstance();
            if (this.setupFunc != null) {
                this.setupFunc.accept(this.instance);
            }
        } else if (!shouldShow && this.instance != null) {
            ((InstanceData)this.instance).delete();
            this.instance = null;
        }
        return this;
    }

    public Optional<D> get() {
        return Optional.ofNullable(this.instance);
    }

    public void delete() {
        if (this.instance != null) {
            ((InstanceData)this.instance).delete();
        }
    }

    @FunctionalInterface
    public static interface ICondition {
        public boolean shouldShow();
    }
}

