/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.model.IndexedModel;
import com.jozufozu.flywheel.backend.model.ModelRenderer;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.util.AttribUtil;
import java.util.function.Supplier;

public class ArrayModelRenderer
extends ModelRenderer {
    protected GlVertexArray vao;

    public ArrayModelRenderer(Supplier<IModel> model) {
        super(model);
    }

    @Override
    public void draw() {
        if (!this.initialized) {
            this.init();
        }
        if (!this.isValid()) {
            return;
        }
        this.vao.bind();
        this.model.drawCall();
        this.vao.unbind();
    }

    @Override
    protected void init() {
        this.initialized = true;
        IModel model = (IModel)this.modelSupplier.get();
        if (model.empty()) {
            return;
        }
        this.model = new IndexedModel(model);
        this.vao = new GlVertexArray();
        this.vao.bind();
        this.model.setupState();
        AttribUtil.enableArrays(this.model.getAttributeCount());
        this.vao.unbind();
        this.model.clearState();
    }
}

