/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.loading;

import com.jozufozu.flywheel.backend.loading.IProcessingStage;
import com.jozufozu.flywheel.backend.loading.Shader;
import java.util.LinkedList;

public class ShaderTransformer {
    private final LinkedList<IProcessingStage> stages = new LinkedList();

    public ShaderTransformer pushStage(IProcessingStage stage) {
        if (stage != null) {
            this.stages.addLast(stage);
        }
        return this;
    }

    public ShaderTransformer popStage() {
        this.stages.removeLast();
        return this;
    }

    public ShaderTransformer prependStage(IProcessingStage stage) {
        if (stage != null) {
            this.stages.addFirst(stage);
        }
        return this;
    }

    public void transformSource(Shader shader) {
        for (IProcessingStage stage : this.stages) {
            stage.process(shader);
        }
    }
}

