/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;

public class MappedBufferRange
extends MappedBuffer {
    long offset;
    long length;
    int access;

    public MappedBufferRange(GlBuffer buffer, long offset, long length, int access) {
        super(buffer);
        this.offset = offset;
        this.length = length;
        this.access = access;
    }

    @Override
    public MappedBuffer position(int p) {
        if ((long)p < this.offset || (long)p >= this.offset + this.length) {
            throw new IndexOutOfBoundsException("Index " + p + " is not mapped");
        }
        return super.position(p - (int)this.offset);
    }

    @Override
    protected void checkAndMap() {
        if (!this.mapped) {
            this.setInternal(Backend.getInstance().compat.mapBufferRange.mapBuffer(this.owner.type, this.offset, this.length, this.access));
            this.mapped = true;
        }
    }
}

