/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCaveStalactites;
import com.github.alexthe666.iceandfire.world.gen.WorldGenDragonCave;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenIceDragonCave
extends WorldGenDragonCave {
    public static ResourceLocation ICE_DRAGON_CHEST = new ResourceLocation("iceandfire", "chest/ice_dragon_female_cave");
    public static ResourceLocation ICE_DRAGON_CHEST_MALE = new ResourceLocation("iceandfire", "chest/ice_dragon_male_cave");

    public WorldGenIceDragonCave(Codec<NoFeatureConfig> codec) {
        super(codec);
        this.DRAGON_CHEST = ICE_DRAGON_CHEST;
        this.DRAGON_MALE_CHEST = ICE_DRAGON_CHEST_MALE;
        this.CEILING_DECO = new WorldGenCaveStalactites(IafBlockRegistry.FROZEN_STONE, 3);
        this.PALETTE_BLOCK1 = IafBlockRegistry.FROZEN_STONE.func_176223_P();
        this.PALETTE_BLOCK2 = IafBlockRegistry.FROZEN_COBBLESTONE.func_176223_P();
        this.TREASURE_PILE = IafBlockRegistry.SILVER_PILE.func_176223_P();
        this.PALETTE_ORE1 = IafBlockRegistry.SAPPHIRE_ORE.func_176223_P();
        this.PALETTE_ORE2 = Blocks.field_150412_bA.func_176223_P();
        this.generateGemOre = IafConfig.generateSapphireOre;
    }

    @Override
    EntityDragonBase createDragon(ISeedReader worldIn, Random rand, BlockPos position, int dragonAge) {
        EntityIceDragon dragon = new EntityIceDragon((EntityType)IafEntityRegistry.ICE_DRAGON.get(), (World)worldIn.func_201672_e());
        dragon.setGender(this.isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.func_233686_v_(true);
        dragon.homePos = new HomePosition(position, (World)worldIn.func_201672_e());
        dragon.setHunger(50);
        return dragon;
    }
}

