/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenHydraCave
extends Feature<NoFeatureConfig> {
    public static final ResourceLocation HYDRA_CHEST = new ResourceLocation("iceandfire", "chest/hydra_cave");
    protected static final ConfiguredFeature SWAMP_FEATURE = Features.field_243875_bU;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenHydraCave(Codec<NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator p_230362_3_, Random rand, BlockPos position, NoFeatureConfig p_230362_6_) {
        if (!IafWorldRegistry.isDimensionListedForFeatures((IServerWorld)worldIn)) {
            return false;
        }
        if (!(IafConfig.generateHydraCaves && rand.nextInt(IafConfig.generateHydraChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((IWorld)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((IServerWorld)worldIn, position))) {
            return false;
        }
        position = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, position);
        int i1 = 8;
        int i2 = i1 - 2;
        int dist = 6;
        if (worldIn.func_175623_d(position.func_177982_a(i1 - dist, -3, -i1 + dist)) || worldIn.func_175623_d(position.func_177982_a(i1 - dist, -3, i1 - dist)) || worldIn.func_175623_d(position.func_177982_a(-i1 + dist, -3, -i1 + dist)) || worldIn.func_175623_d(position.func_177982_a(-i1 + dist, -3, i1 - dist))) {
            return false;
        }
        int ySize = rand.nextInt(2);
        int j = i1 + rand.nextInt(2);
        int k = 5 + ySize;
        int l = i1 + rand.nextInt(2);
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            boolean isNotInDoorway;
            boolean doorwayX = blockpos.func_177958_n() >= position.func_177958_n() - 2 + rand.nextInt(2) && blockpos.func_177958_n() <= position.func_177958_n() + 2 + rand.nextInt(2);
            boolean doorwayZ = blockpos.func_177952_p() >= position.func_177952_p() - 2 + rand.nextInt(2) && blockpos.func_177952_p() <= position.func_177952_p() + 2 + rand.nextInt(2);
            boolean bl = isNotInDoorway = !doorwayX && !doorwayZ && blockpos.func_177956_o() > position.func_177956_o() || blockpos.func_177956_o() > position.func_177956_o() + k - (1 + rand.nextInt(2));
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f))) continue;
            if (!(worldIn.func_180495_p(position).func_177230_c() instanceof ChestBlock) && isNotInDoorway) {
                worldIn.func_180501_a(blockpos, Blocks.field_196658_i.func_176223_P(), 3);
                if (worldIn.func_180495_p(position.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
                    worldIn.func_180501_a(blockpos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
                }
                if (rand.nextInt(4) == 0) {
                    worldIn.func_180501_a(blockpos.func_177984_a(), Blocks.field_150349_c.func_176223_P(), 2);
                }
                if (rand.nextInt(9) == 0) {
                    SWAMP_FEATURE.func_242765_a(worldIn, p_230362_3_, rand, blockpos.func_177984_a());
                }
            }
            if (blockpos.func_177956_o() == position.func_177956_o()) {
                worldIn.func_180501_a(blockpos, Blocks.field_196658_i.func_176223_P(), 3);
            }
            if (blockpos.func_177956_o() > position.func_177956_o() - 1 || worldIn.func_180495_p(blockpos).func_200132_m()) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150348_b.func_176223_P(), 3);
        }
        ySize = rand.nextInt(2);
        j = i2 + rand.nextInt(2);
        k = 4 + ySize;
        l = i2 + rand.nextInt(2);
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f)) || blockpos.func_177956_o() <= position.func_177956_o() || worldIn.func_180495_p(position).func_177230_c() instanceof ChestBlock) continue;
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        for (BlockPos blockpos : BlockPos.func_218281_b((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k + 8, l)).map(BlockPos::func_185334_h).collect(Collectors.toSet())) {
            TileEntity tileentity1;
            if (!(blockpos.func_177951_i((Vector3i)position) <= (double)(f * f)) || blockpos.func_177956_o() != position.func_177956_o()) continue;
            if (rand.nextInt(30) == 0 && this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) {
                worldIn.func_180501_a(blockpos.func_177981_b(1), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                if (!(worldIn.func_180495_p(blockpos.func_177981_b(1)).func_177230_c() instanceof ChestBlock) || !((tileentity1 = worldIn.func_175625_s(blockpos.func_177981_b(1))) instanceof ChestTileEntity)) continue;
                ((ChestTileEntity)tileentity1).func_189404_a(HYDRA_CHEST, rand.nextLong());
                continue;
            }
            if (rand.nextInt(45) == 0 && this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) {
                worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)Blocks.field_196703_eM.func_176223_P().func_206870_a((Property)SkullBlock.field_196294_a, (Comparable)Integer.valueOf(rand.nextInt(15))), 2);
                tileentity1 = worldIn.func_175625_s(blockpos.func_177981_b(1));
                continue;
            }
            if (rand.nextInt(35) == 0 && this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) {
                worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 2);
                for (Direction facing : Direction.values()) {
                    if (!(rand.nextFloat() < 0.3f) || facing == Direction.DOWN) continue;
                    worldIn.func_180501_a(blockpos.func_177984_a().func_177972_a(facing), Blocks.field_196642_W.func_176223_P(), 2);
                }
                continue;
            }
            if (rand.nextInt(15) == 0 && this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) {
                worldIn.func_180501_a(blockpos.func_177984_a(), Blocks.field_196804_gh.func_176223_P(), 2);
                continue;
            }
            if (rand.nextInt(15) != 0 || !this.isTouchingAir((IWorld)worldIn, blockpos.func_177984_a())) continue;
            worldIn.func_180501_a(blockpos.func_177984_a(), rand.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P(), 2);
        }
        EntityHydra hydra = new EntityHydra(IafEntityRegistry.HYDRA, (World)worldIn.func_201672_e());
        hydra.setVariant(rand.nextInt(3));
        hydra.func_213390_a(position, 15);
        hydra.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        worldIn.func_217376_c((Entity)hydra);
        return true;
    }

    private boolean isTouchingAir(IWorld worldIn, BlockPos pos) {
        boolean isTouchingAir = true;
        for (Direction direction : HORIZONTALS) {
            if (worldIn.func_175623_d(pos.func_177972_a(direction))) continue;
            isTouchingAir = false;
        }
        return isTouchingAir;
    }
}

