/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class IafWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "iceandfire_general";
    protected BlockPos lastGeneratedDangerousStructure = BlockPos.field_177992_a;
    private World world;
    private int tickCounter;

    public IafWorldData() {
        super(IDENTIFIER);
    }

    public IafWorldData(World world) {
        super(IDENTIFIER);
        this.world = world;
        this.func_76185_a();
    }

    public static IafWorldData get(World world) {
        if (world instanceof ServerWorld) {
            ServerWorld overworld = world.func_73046_m().func_71218_a(world.func_234923_W_());
            DimensionSavedDataManager storage = overworld.func_217481_x();
            IafWorldData data = (IafWorldData)storage.func_215752_a(IafWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.func_76185_a();
            }
            return data;
        }
        return null;
    }

    public void setLastGeneratedDangerousStructure(BlockPos pos) {
        this.lastGeneratedDangerousStructure = pos;
        this.func_76185_a();
    }

    public BlockPos getLastGeneratedDangerousStructure() {
        return this.lastGeneratedDangerousStructure;
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        this.lastGeneratedDangerousStructure = new BlockPos(nbt.func_74762_e("LastX"), nbt.func_74762_e("LastY"), nbt.func_74762_e("LastZ"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        compound.func_74768_a("LastX", this.lastGeneratedDangerousStructure.func_177958_n());
        compound.func_74768_a("LastY", this.lastGeneratedDangerousStructure.func_177956_o());
        compound.func_74768_a("LastZ", this.lastGeneratedDangerousStructure.func_177952_p());
        return compound;
    }
}

