/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.recipe;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DragonForgeRecipe
implements IRecipe<TileEntityDragonforge> {
    private final Ingredient input;
    private final Ingredient blood;
    private final ItemStack result;
    private final String dragonType;
    private final int cookTime;
    private final ResourceLocation recipeId;

    public DragonForgeRecipe(ResourceLocation recipeId, Ingredient input, Ingredient blood, ItemStack result, String dragonType, int cookTime) {
        this.recipeId = recipeId;
        this.input = input;
        this.blood = blood;
        this.result = result;
        this.dragonType = dragonType;
        this.cookTime = cookTime;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public Ingredient getBlood() {
        return this.blood;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public String getDragonType() {
        return this.dragonType;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean matches(TileEntityDragonforge inv, World worldIn) {
        return this.input.test(inv.func_70301_a(0)) && this.blood.test(inv.func_70301_a(1)) && this.dragonType.equals(inv.getTypeID());
    }

    public boolean isValidInput(ItemStack stack) {
        return this.input.test(stack);
    }

    public boolean isValidBlood(ItemStack blood) {
        return this.blood.test(blood);
    }

    public ItemStack getCraftingResult(TileEntityDragonforge inv) {
        return this.result;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)IafBlockRegistry.DRAGONFORGE_FIRE_CORE);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)IafRecipeRegistry.DRAGONFORGE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return IafRecipeRegistry.DRAGON_FORGE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DragonForgeRecipe> {
        public DragonForgeRecipe read(ResourceLocation recipeId, JsonObject json) {
            String dragonType = JSONUtils.func_151200_h((JsonObject)json, (String)"dragon_type");
            Ingredient input = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            Ingredient blood = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"blood"));
            int cookTime = JSONUtils.func_151203_m((JsonObject)json, (String)"cook_time");
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new DragonForgeRecipe(recipeId, input, blood, result, dragonType, cookTime);
        }

        public DragonForgeRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int cookTime = buffer.readInt();
            String dragonType = buffer.func_218666_n();
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient blood = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack result = buffer.func_150791_c();
            return new DragonForgeRecipe(recipeId, input, blood, result, dragonType, cookTime);
        }

        public void write(PacketBuffer buffer, DragonForgeRecipe recipe) {
            buffer.writeInt(recipe.cookTime);
            buffer.func_180714_a(recipe.dragonType);
            recipe.input.func_199564_a(buffer);
            recipe.blood.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

