/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class PathJobMoveToLocation
extends AbstractPathJob {
    private static final float DESTINATION_SLACK_NONE = 0.1f;
    private static final float DESTINATION_SLACK_ADJACENT = (float)Math.sqrt(2.0);
    private final BlockPos destination;
    private float destinationSlack = 0.1f;

    public PathJobMoveToLocation(World world, BlockPos start, BlockPos end, int range, LivingEntity entity) {
        super(world, start, end, range, entity);
        this.destination = new BlockPos((Vector3i)end);
    }

    @Override
    @Nullable
    protected Path search() {
        if (Pathfinding.isDebug()) {
            IceAndFire.LOGGER.info(String.format("Pathfinding from [%d,%d,%d] to [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        if (this.getGroundHeight(null, this.destination) != this.destination.func_177956_o()) {
            this.destinationSlack = DESTINATION_SLACK_ADJACENT;
        }
        return super.search();
    }

    @Override
    protected BlockPos getPathTargetPos(Node finalNode) {
        return this.destination;
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return Math.sqrt(this.destination.func_177951_i((Vector3i)pos));
    }

    @Override
    protected boolean isAtDestination(Node n) {
        if (this.destinationSlack <= 0.1f) {
            return n.pos.func_177958_n() == this.destination.func_177958_n() && n.pos.func_177956_o() == this.destination.func_177956_o() && n.pos.func_177952_p() == this.destination.func_177952_p();
        }
        if (n.pos.func_177956_o() == this.destination.func_177956_o() - 1) {
            return this.destination.func_218141_a(new Vector3i(n.pos.func_177958_n(), this.destination.func_177956_o(), n.pos.func_177952_p()), (double)DESTINATION_SLACK_ADJACENT);
        }
        return this.destination.func_218141_a((Vector3i)n.pos, (double)DESTINATION_SLACK_ADJACENT);
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return this.destination.func_177951_i((Vector3i)n.pos);
    }
}

