/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Node;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    protected final BlockPos avoid;
    protected final int avoidDistance;

    public PathJobMoveAwayFromLocation(World world, BlockPos start, BlockPos avoid, int avoidDistance, int range, LivingEntity entity) {
        super(world, start, avoid, range, entity);
        this.avoid = new BlockPos((Vector3i)avoid);
        this.avoidDistance = avoidDistance;
    }

    @Override
    @Nullable
    protected Path search() {
        if (Pathfinding.isDebug()) {
            IceAndFire.LOGGER.info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.avoid.func_177958_n(), this.avoid.func_177956_o(), this.avoid.func_177952_p()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(BlockPos pos) {
        return -this.avoid.func_177951_i((Vector3i)pos);
    }

    @Override
    protected boolean isAtDestination(Node n) {
        return Math.sqrt(this.avoid.func_177951_i((Vector3i)n.pos)) > (double)this.avoidDistance;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return -this.avoid.func_177951_i((Vector3i)n.pos);
    }
}

