/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.FlaggedPathPoint;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class NodeProcessorDeathWorm
extends NodeProcessor {
    public PathPoint func_186318_b() {
        return this.func_176159_a(MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72340_a), MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5)), MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72339_c));
    }

    public FlaggedPathPoint func_224768_a(double x, double y, double z) {
        return new FlaggedPathPoint(this.func_176159_a(MathHelper.func_76128_c((double)(x - 0.4)), MathHelper.func_76128_c((double)(y + 0.5)), MathHelper.func_76128_c((double)(z - 0.4))));
    }

    public PathNodeType func_186319_a(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return this.func_186330_a(blockaccessIn, x, y, z);
    }

    public PathNodeType func_186330_a(IBlockReader worldIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (!this.isPassable(worldIn, blockpos.func_177977_b()) && (blockstate.func_196958_f() || this.isPassable(worldIn, blockpos))) {
            return PathNodeType.BREACH;
        }
        return this.isPassable(worldIn, blockpos) ? PathNodeType.WATER : PathNodeType.BLOCKED;
    }

    public int func_222859_a(PathPoint[] p_222859_1_, PathPoint p_222859_2_) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            PathPoint pathpoint = this.getSandNode(p_222859_2_.field_75839_a + direction.func_82601_c(), p_222859_2_.field_75837_b + direction.func_96559_d(), p_222859_2_.field_75838_c + direction.func_82599_e());
            if (pathpoint == null || pathpoint.field_75842_i) continue;
            p_222859_1_[i++] = pathpoint;
        }
        return i;
    }

    @Nullable
    private PathPoint getSandNode(int p_186328_1_, int p_186328_2_, int p_186328_3_) {
        PathNodeType pathnodetype = this.isFree(p_186328_1_, p_186328_2_, p_186328_3_);
        return pathnodetype != PathNodeType.BREACH && pathnodetype != PathNodeType.WATER ? null : this.func_176159_a(p_186328_1_, p_186328_2_, p_186328_3_);
    }

    private PathNodeType isFree(int p_186327_1_, int p_186327_2_, int p_186327_3_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = p_186327_1_; i < p_186327_1_ + this.field_176168_c; ++i) {
            for (int j = p_186327_2_; j < p_186327_2_ + this.field_176165_d; ++j) {
                for (int k = p_186327_3_; k < p_186327_3_ + this.field_176166_e; ++k) {
                    BlockState blockstate = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(i, j, k));
                    if (this.isPassable((IBlockReader)this.field_176169_a, blockpos$mutable.func_177977_b()) || !blockstate.func_196958_f() && !this.isPassable((IBlockReader)this.field_176169_a, (BlockPos)blockpos$mutable)) continue;
                    return PathNodeType.BREACH;
                }
            }
        }
        BlockState blockstate1 = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutable);
        return this.isPassable(blockstate1) ? PathNodeType.WATER : PathNodeType.BLOCKED;
    }

    private boolean isPassable(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151595_p || world.func_180495_p(pos).func_185904_a() == Material.field_151579_a;
    }

    private boolean isPassable(BlockState state) {
        return state.func_185904_a() == Material.field_151595_p || state.func_185904_a() == Material.field_151579_a;
    }
}

