/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.item.CustomArmorMaterial;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemSeaSerpentArmor
extends ArmorItem {
    public EnumSeaSerpent armor_type;

    public ItemSeaSerpentArmor(EnumSeaSerpent armorType, CustomArmorMaterial material, EquipmentSlotType slot) {
        super((IArmorMaterial)material, slot, new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS));
        this.armor_type = armorType;
    }

    public String func_77658_a() {
        switch (this.field_77881_a) {
            case HEAD: {
                return "item.iceandfire.sea_serpent_helmet";
            }
            case CHEST: {
                return "item.iceandfire.sea_serpent_chestplate";
            }
            case LEGS: {
                return "item.iceandfire.sea_serpent_leggings";
            }
            case FEET: {
                return "item.iceandfire.sea_serpent_boots";
            }
        }
        return "item.iceandfire.sea_serpent_helmet";
    }

    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity LivingEntity2, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((BipedModel)IceAndFire.PROXY.getArmorModel(this.field_77881_a == EquipmentSlotType.LEGS ? 9 : 8));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "iceandfire:textures/models/armor/armor_tide_" + this.armor_type.resourceName + (slot == EquipmentSlotType.LEGS ? "_legs.png" : ".png");
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        player.func_195064_c(new EffectInstance(Effects.field_76427_o, 50, 0, false, false));
        if (player.func_70026_G()) {
            int headMod = player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
            int chestMod = player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
            int legMod = player.func_184582_a(EquipmentSlotType.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
            int footMod = player.func_184582_a(EquipmentSlotType.FEET).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
            player.func_195064_c(new EffectInstance(Effects.field_76420_g, 50, headMod + chestMod + legMod + footMod - 1, false, false));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("sea_serpent." + this.armor_type.resourceName).func_240699_a_(this.armor_type.color));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.sea_serpent_armor.desc_0").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.iceandfire.sea_serpent_armor.desc_1").func_240699_a_(TextFormatting.GRAY));
    }
}

