/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.item.CustomArmorMaterial;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.enums.EnumDragonArmor;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.item.IProtectAgainstDragonItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemScaleArmor
extends ArmorItem
implements IProtectAgainstDragonItem {
    public EnumDragonArmor armor_type;
    public EnumDragonEgg eggType;

    public ItemScaleArmor(EnumDragonEgg eggType, EnumDragonArmor armorType, CustomArmorMaterial material, EquipmentSlotType slot) {
        super((IArmorMaterial)material, slot, new Item.Properties().func_200916_a(IceAndFire.TAB_ITEMS));
        this.armor_type = armorType;
        this.eggType = eggType;
    }

    public String func_77658_a() {
        switch (this.field_77881_a) {
            case HEAD: {
                return "item.iceandfire.dragon_helmet";
            }
            case CHEST: {
                return "item.iceandfire.dragon_chestplate";
            }
            case LEGS: {
                return "item.iceandfire.dragon_leggings";
            }
            case FEET: {
                return "item.iceandfire.dragon_boots";
            }
        }
        return "item.iceandfire.dragon_helmet";
    }

    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity LivingEntity2, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        int dragonType = DragonType.getIntFromType(this.armor_type.eggType.dragonType);
        if (dragonType == 0) {
            return (A)((BipedModel)IceAndFire.PROXY.getArmorModel(this.field_77881_a == EquipmentSlotType.LEGS ? 1 : 0));
        }
        if (dragonType == 1) {
            return (A)((BipedModel)IceAndFire.PROXY.getArmorModel(this.field_77881_a == EquipmentSlotType.LEGS ? 3 : 2));
        }
        if (dragonType == 2) {
            return (A)((BipedModel)IceAndFire.PROXY.getArmorModel(this.field_77881_a == EquipmentSlotType.LEGS ? 19 : 18));
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "iceandfire:textures/models/armor/" + this.armor_type.name() + (slot == EquipmentSlotType.LEGS ? "_legs.png" : ".png");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("dragon." + this.eggType.toString().toLowerCase()).func_240699_a_(this.eggType.color));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.dragonscales_armor.desc").func_240699_a_(TextFormatting.GRAY));
    }
}

