/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.ClientProxy;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.gui.IceAndFireMainMenu;
import com.github.alexthe666.iceandfire.client.particle.CockatriceBeamRender;
import com.github.alexthe666.iceandfire.client.render.entity.RenderChain;
import com.github.alexthe666.iceandfire.client.render.pathfinding.RenderPath;
import com.github.alexthe666.iceandfire.client.render.tile.RenderFrozenState;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.props.SirenProperties;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="iceandfire", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation SIREN_SHADER = new ResourceLocation("iceandfire:shaders/post/siren.json");
    private final Random rand = new Random();

    private static boolean shouldCancelRender(LivingEntity living) {
        if (living.func_184187_bx() != null && living.func_184187_bx() instanceof EntityDragonBase) {
            return ClientProxy.currentDragonRiders.contains(living.func_110124_au()) || living == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a();
        }
        return false;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (Pathfinding.isDebug()) {
            RenderPath.debugDraw(event.getPartialTicks(), event.getMatrixStack());
        }
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityDragonBase) {
            int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
            float scale = ((EntityDragonBase)player.func_184187_bx()).getRenderSize() / 3.0f;
            if (Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.THIRD_PERSON_BACK || Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.THIRD_PERSON_FRONT) {
                if (currentView == 1) {
                    event.getInfo().func_216782_a(-event.getInfo().func_216779_a((double)(scale * 1.2f)), 0.0, 0.0);
                } else if (currentView == 2) {
                    event.getInfo().func_216782_a(-event.getInfo().func_216779_a((double)(scale * 3.0f)), 0.0, 0.0);
                } else if (currentView == 3) {
                    event.getInfo().func_216782_a(-event.getInfo().func_216779_a((double)(scale * 5.0f)), 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getEntityLiving() instanceof ICustomMoveController) {
            LivingEntity entity = event.getEntityLiving();
            Entity moveController = (Entity)((ICustomMoveController)event.getEntityLiving());
            if (entity.func_184187_bx() != null && entity.func_184187_bx() == mc.field_71439_g) {
                byte previousState = moveController.getControlState();
                moveController.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
                byte controlState = moveController.getControlState();
                if (controlState != previousState) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(entity.func_145782_y(), controlState, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (player.field_70170_p.field_72995_K && player.func_184187_bx() instanceof ICustomMoveController) {
                Entity entity = player.func_184187_bx();
                Entity moveController = (Entity)((ICustomMoveController)player.func_184187_bx());
                byte previousState = moveController.getControlState();
                moveController.up(mc.field_71474_y.field_74314_A.func_151470_d());
                moveController.down(IafKeybindRegistry.dragon_down.func_151470_d());
                moveController.attack(IafKeybindRegistry.dragon_strike.func_151470_d());
                moveController.dismount(mc.field_71474_y.field_228046_af_.func_151470_d());
                moveController.strike(IafKeybindRegistry.dragon_fireAttack.func_151470_d());
                byte controlState = moveController.getControlState();
                if (controlState != previousState) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(entity.func_145782_y(), controlState, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()));
                }
            }
            if (player.field_70170_p.field_72995_K && IafKeybindRegistry.dragon_change_view.func_151470_d()) {
                int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
                currentView = currentView + 1 > 3 ? 0 : ++currentView;
                IceAndFire.PROXY.setDragon3rdPersonView(currentView);
            }
            if (player.field_70170_p.field_72995_K) {
                GameRenderer renderer = Minecraft.func_71410_x().field_71460_t;
                EntitySiren siren = SirenProperties.getSiren((LivingEntity)player);
                if (IafConfig.sirenShader && siren == null && renderer != null && renderer.func_147706_e() != null && SIREN_SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                    renderer.func_181022_b();
                }
                if (siren == null) {
                    return;
                }
                boolean isCharmed = SirenProperties.isCharmed((LivingEntity)player);
                if (IafConfig.sirenShader && !isCharmed && renderer != null && renderer.func_147706_e() != null && SIREN_SHADER.toString().equals(renderer.func_147706_e().func_148022_b())) {
                    renderer.func_181022_b();
                }
                if (isCharmed) {
                    if (player.field_70170_p.field_72995_K && this.rand.nextInt(40) == 0) {
                        IceAndFire.PROXY.spawnParticle(EnumParticles.Siren_Appearance, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), siren.getHairColor(), 0.0, 0.0);
                    }
                    if (IafConfig.sirenShader && renderer.func_147706_e() == null) {
                        renderer.func_175069_a(SIREN_SHADER);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPreRenderLiving(RenderLivingEvent.Pre event) {
        if (ClientEvents.shouldCancelRender(event.getEntity()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPostRenderLiving(RenderLivingEvent.Post event) {
        if (ClientEvents.shouldCancelRender(event.getEntity()) && event.isCancelable()) {
            event.setCanceled(true);
        }
        LivingEntity entity = event.getEntity();
        MiscProperties.getTargetedBy(entity).forEach(caster -> CockatriceBeamRender.render((Entity)entity, (Entity)caster, event.getMatrixStack(), event.getBuffers(), event.getPartialRenderTick()));
        if (FrozenProperties.isFrozen(event.getEntity())) {
            RenderFrozenState.render(event.getEntity(), event.getMatrixStack(), event.getBuffers(), event.getLight());
        }
        RenderChain.render(entity, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
    }

    @SubscribeEvent
    public void onGuiOpened(GuiOpenEvent event) {
        if (IafConfig.customMainMenu && event.getGui() instanceof MainMenuScreen && !(event.getGui() instanceof IceAndFireMainMenu)) {
            event.setGui((Screen)new IceAndFireMainMenu());
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        EntityDragonBase dragon;
        if (IafConfig.dragonAuto3rdPerson && event.getEntityBeingMounted() instanceof EntityDragonBase && event.getWorldObj().field_72995_K && event.getEntityMounting() == Minecraft.func_71410_x().field_71439_g && (dragon = (EntityDragonBase)event.getEntityBeingMounted()).func_70909_n() && dragon.func_152114_e((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            if (event.isDismounting()) {
                Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.values()[IceAndFire.PROXY.getPreviousViewType()]);
            } else {
                IceAndFire.PROXY.setPreviousViewType(Minecraft.func_71410_x().field_71474_y.func_243230_g().ordinal());
                Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.values()[1]);
                IceAndFire.PROXY.setDragon3rdPersonView(2);
            }
        }
    }
}

