/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.enums;

import com.github.alexthe666.iceandfire.item.ItemBestiary;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public enum EnumBestiaryPages {
    INTRODUCTION(2),
    FIREDRAGON(4),
    FIREDRAGONEGG(1),
    ICEDRAGON(4),
    ICEDRAGONEGG(1),
    TAMEDDRAGONS(3),
    MATERIALS(2),
    ALCHEMY(1),
    DRAGONFORGE(3),
    HIPPOGRYPH(1),
    GORGON(1),
    PIXIE(1),
    CYCLOPS(2),
    SIREN(2),
    HIPPOCAMPUS(2),
    DEATHWORM(3),
    COCKATRICE(2),
    STYMPHALIANBIRD(1),
    TROLL(2),
    MYRMEX(4),
    AMPHITHERE(2),
    SEASERPENT(2),
    HYDRA(2),
    DREAD_MOBS(1),
    LIGHTNINGDRAGON(5),
    LIGHTNINGDRAGONEGG(1),
    GHOST(1);

    public static final ImmutableList<EnumBestiaryPages> ALL_PAGES;
    public static final ImmutableList<Integer> ALL_INDEXES;
    public int pages;

    private EnumBestiaryPages(int pages) {
        this.pages = pages;
    }

    public static Set<EnumBestiaryPages> containedPages(Collection<Integer> pages) {
        return pages.stream().map(arg_0 -> ALL_PAGES.get(arg_0)).collect(Collectors.toSet());
    }

    public static boolean hasAllPages(ItemStack book) {
        return Ints.asList((int[])book.func_77978_p().func_74759_k("Pages")).containsAll((Collection<?>)ALL_INDEXES);
    }

    public static List<Integer> enumToInt(List<EnumBestiaryPages> pages) {
        return pages.stream().map(Enum::ordinal).collect(Collectors.toList());
    }

    public static EnumBestiaryPages getRand() {
        return EnumBestiaryPages.values()[ThreadLocalRandom.current().nextInt(EnumBestiaryPages.values().length)];
    }

    public static void addRandomPage(ItemStack book) {
        List<EnumBestiaryPages> list;
        if (book.func_77973_b() instanceof ItemBestiary && !(list = EnumBestiaryPages.possiblePages(book)).isEmpty()) {
            EnumBestiaryPages.addPage(list.get(ThreadLocalRandom.current().nextInt(list.size())), book);
        }
    }

    public static List<EnumBestiaryPages> possiblePages(ItemStack book) {
        if (book.func_77973_b() instanceof ItemBestiary) {
            CompoundNBT tag = book.func_77978_p();
            Set<EnumBestiaryPages> containedPages = EnumBestiaryPages.containedPages(Ints.asList((int[])tag.func_74759_k("Pages")));
            ArrayList<EnumBestiaryPages> possiblePages = new ArrayList<EnumBestiaryPages>((Collection<EnumBestiaryPages>)ALL_PAGES);
            possiblePages.removeAll(containedPages);
            return possiblePages;
        }
        return Collections.emptyList();
    }

    public static boolean addPage(EnumBestiaryPages page, ItemStack book) {
        boolean flag = false;
        if (book.func_77973_b() instanceof ItemBestiary) {
            CompoundNBT tag = book.func_77978_p();
            ArrayList<Integer> already = new ArrayList<Integer>(Ints.asList((int[])tag.func_74759_k("Pages")));
            if (!already.contains(page.ordinal())) {
                already.add(page.ordinal());
                flag = true;
            }
            tag.func_74783_a("Pages", Ints.toArray(already));
        }
        return flag;
    }

    @Nullable
    public static EnumBestiaryPages fromInt(int index) {
        if (index < 0) {
            return null;
        }
        int length = EnumBestiaryPages.values().length;
        return EnumBestiaryPages.values()[index % length];
    }

    static {
        ALL_PAGES = ImmutableList.copyOf((Object[])EnumBestiaryPages.values());
        ALL_INDEXES = ImmutableList.copyOf((Iterator)IntStream.range(0, EnumBestiaryPages.values().length).iterator());
    }
}

