/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;

public class MyrmexTrades {
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> DESERT_WORKER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new DesertResinForItemsTrade((IItemProvider)Items.field_221582_j, 64, 1, 5), new DesertResinForItemsTrade((IItemProvider)Items.field_221548_A, 64, 1, 5), new ItemsForDesertResinTrade(Items.field_221599_aA, 2, 8, 5, 2), new DesertResinForItemsTrade((IItemProvider)Items.field_151103_aS, 10, 1, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(Items.field_221552_E, 1, 6, 3, 2), new DesertResinForItemsTrade((IItemProvider)Items.field_151102_aT, 15, 2, 1), new ItemsForDesertResinTrade(Items.field_151055_y, 1, 64, 5, 2), new ItemsForDesertResinTrade(IafItemRegistry.COPPER_NUGGET, 1, 4, 10)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> JUNGLE_WORKER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new JungleResinForItemsTrade((IItemProvider)Items.field_221582_j, 64, 1, 5), new ItemsForJungleResinTrade(Items.field_151127_ba, 1, 20, 3, 1), new ItemsForJungleResinTrade(Items.field_221640_ah, 1, 64, 5, 1), new JungleResinForItemsTrade((IItemProvider)Items.field_151103_aS, 10, 1, 5)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(Items.field_221551_D, 2, 15, 3, 2), new JungleResinForItemsTrade((IItemProvider)Items.field_151102_aT, 15, 2, 3), new ItemsForJungleResinTrade(Items.field_151055_y, 1, 64, 5, 2), new ItemsForJungleResinTrade(IafItemRegistry.COPPER_NUGGET, 1, 4, 10)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> DESERT_SOLDIER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new DesertResinForItemsTrade((IItemProvider)Items.field_151103_aS, 7, 1, 3), new DesertResinForItemsTrade((IItemProvider)Items.field_151008_G, 16, 3, 3), new DesertResinForItemsTrade((IItemProvider)Items.field_151016_H, 5, 1, 4), new ItemsForDesertResinTrade(Items.field_179558_bo, 1, 3, 6, 2), new DesertResinForItemsTrade((IItemProvider)Items.field_191525_da, 4, 1, 4), new ItemsForDesertResinTrade(Items.field_151076_bf, 2, 2, 7), new ItemsForDesertResinTrade(IafItemRegistry.SILVER_NUGGET, 4, 1, 15)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(Items.field_221774_cw, 1, 15, 6, 2), new ItemsForDesertResinTrade(Items.field_151074_bl, 1, 4, 6, 2), new ItemsForDesertResinTrade(IafItemRegistry.TROLL_TUSK, 6, 1, 4, 2), new DesertResinForItemsTrade((IItemProvider)IafItemRegistry.DRAGON_BONE, 6, 2, 3)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> JUNGLE_SOLDIER = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new JungleResinForItemsTrade((IItemProvider)Items.field_151103_aS, 7, 1, 3), new JungleResinForItemsTrade((IItemProvider)Items.field_151008_G, 16, 3, 3), new JungleResinForItemsTrade((IItemProvider)Items.field_151016_H, 5, 1, 4), new ItemsForJungleResinTrade(Items.field_151110_aK, 1, 4, 6, 2), new JungleResinForItemsTrade((IItemProvider)Items.field_191525_da, 4, 1, 4), new ItemsForJungleResinTrade(Items.field_151076_bf, 2, 2, 7), new ItemsForJungleResinTrade(IafItemRegistry.SILVER_NUGGET, 1, 4, 15)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(Items.field_151078_bh, 1, 15, 6, 2), new ItemsForJungleResinTrade(Items.field_151074_bl, 1, 4, 6, 2), new ItemsForJungleResinTrade(IafItemRegistry.TROLL_TUSK, 6, 1, 4, 2), new JungleResinForItemsTrade((IItemProvider)IafItemRegistry.DRAGON_BONE, 6, 2, 3)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> DESERT_SENTINEL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new DesertResinForItemsTrade((IItemProvider)Items.field_151070_bp, 10, 2, 3), new DesertResinForItemsTrade((IItemProvider)Items.field_151170_bI, 2, 1, 2), new DesertResinForItemsTrade((IItemProvider)Items.field_196089_aZ, 4, 2, 4)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(Items.field_151137_ax, 2, 5, 5, 1), new ItemsForDesertResinTrade(Items.field_151147_al, 2, 3, 4), new ItemsForDesertResinTrade(Items.field_151082_bd, 2, 3, 4), new ItemsForDesertResinTrade(Items.field_179561_bm, 2, 3, 4), new ItemsForDesertResinTrade(Items.field_196182_dv, 15, 1, 2, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> JUNGLE_SENTINEL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new JungleResinForItemsTrade((IItemProvider)Items.field_151070_bp, 10, 2, 3), new JungleResinForItemsTrade((IItemProvider)Items.field_151170_bI, 2, 1, 2), new JungleResinForItemsTrade((IItemProvider)Items.field_196089_aZ, 4, 2, 4)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(Items.field_151137_ax, 2, 5, 5, 1), new ItemsForJungleResinTrade(Items.field_151147_al, 2, 3, 4), new ItemsForJungleResinTrade(Items.field_151082_bd, 2, 3, 4), new ItemsForJungleResinTrade(Items.field_179561_bm, 2, 3, 4), new ItemsForJungleResinTrade(Items.field_196182_dv, 15, 1, 2, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> DESERT_ROYAL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(IafItemRegistry.MANUSCRIPT, 1, 3, 5, 1), new ItemsForDesertResinTrade(IafItemRegistry.WITHER_SHARD, 3, 1, 3, 1), new ItemsForDesertResinTrade(Items.field_151166_bC, 10, 1, 3, 1), new ItemsForDesertResinTrade(Items.field_151128_bU, 2, 4, 3, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(Items.field_151150_bK, 3, 1, 2, 1), new ItemsForDesertResinTrade(Items.field_151064_bs, 5, 1, 3, 1), new ItemsForDesertResinTrade(Items.field_151043_k, 3, 1, 5, 1), new ItemsForDesertResinTrade(IafItemRegistry.SILVER_INGOT, 3, 1, 5, 1), new ItemsForDesertResinTrade(IafItemRegistry.COPPER_INGOT, 2, 2, 3, 1), new ItemsForDesertResinTrade(Items.field_151079_bi, 8, 1, 5, 1), new ItemsForDesertResinTrade(Items.field_179556_br, 3, 1, 5, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> JUNGLE_ROYAL = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(IafItemRegistry.MANUSCRIPT, 1, 3, 5, 1), new ItemsForJungleResinTrade(IafItemRegistry.WITHER_SHARD, 3, 1, 3, 1), new ItemsForJungleResinTrade(Items.field_151166_bC, 10, 1, 3, 1), new ItemsForJungleResinTrade(Items.field_151128_bU, 2, 4, 3, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(Items.field_151150_bK, 3, 1, 2, 1), new ItemsForJungleResinTrade(Items.field_151064_bs, 5, 1, 3, 1), new ItemsForJungleResinTrade(Items.field_151043_k, 3, 1, 5, 1), new ItemsForJungleResinTrade(IafItemRegistry.SILVER_INGOT, 3, 1, 5, 1), new ItemsForJungleResinTrade(IafItemRegistry.COPPER_INGOT, 2, 2, 3, 1), new ItemsForJungleResinTrade(Items.field_151079_bi, 8, 1, 5, 1), new ItemsForJungleResinTrade(Items.field_179556_br, 3, 1, 5, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> DESERT_QUEEN = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 0), 10, 1, 10, 1), new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 1), 20, 1, 8, 1), new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 2), 30, 1, 5, 1), new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 3), 40, 1, 3, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForDesertResinTrade(MyrmexTrades.createEgg(false, 4), 60, 1, 2, 1), new ItemsForDesertResinTrade(Items.field_151166_bC, 15, 1, 9, 1), new ItemsForDesertResinTrade(Items.field_151045_i, 25, 1, 9, 1)}));
    public static final Int2ObjectMap<VillagerTrades.ITrade[]> JUNGLE_QUEEN = MyrmexTrades.createTrades((ImmutableMap<Integer, VillagerTrades.ITrade[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 0), 10, 1, 10, 1), new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 1), 20, 1, 8, 1), new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 2), 30, 1, 5, 1), new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 3), 40, 1, 3, 1)}, (Object)2, (Object)new VillagerTrades.ITrade[]{new ItemsForJungleResinTrade(MyrmexTrades.createEgg(true, 4), 60, 1, 2, 1), new ItemsForDesertResinTrade(Items.field_151166_bC, 15, 1, 9, 1), new ItemsForDesertResinTrade(Items.field_151045_i, 25, 1, 9, 1)}));

    private static ItemStack createEgg(boolean jungle, int caste) {
        ItemStack egg = new ItemStack((IItemProvider)(jungle ? IafItemRegistry.MYRMEX_JUNGLE_EGG : IafItemRegistry.MYRMEX_DESERT_EGG));
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("EggOrdinal", caste);
        egg.func_77982_d(tag);
        return egg;
    }

    private static Int2ObjectMap<VillagerTrades.ITrade[]> createTrades(ImmutableMap<Integer, VillagerTrades.ITrade[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    static class JungleResinForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public JungleResinForItemsTrade(IItemProvider tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.func_199767_j();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((IItemProvider)this.tradeItem, this.count);
            return new MerchantOffer(lvt_3_1_, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForJungleResinTrade
    implements VillagerTrades.ITrade {
        private final ItemStack stack;
        private final int emeraldCount;
        private final int itemCount;
        private final int maxUses;
        private final int exp;
        private final float multiplier;

        public ItemsForJungleResinTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForJungleResinTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForJungleResinTrade(Item item, int JungleResin, int items, int maxUses, int exp) {
            this(new ItemStack((IItemProvider)item), JungleResin, items, maxUses, exp);
        }

        public ItemsForJungleResinTrade(ItemStack stack, int JungleResin, int items, int maxUses, int exp) {
            this(stack, JungleResin, items, maxUses, exp, 0.05f);
        }

        public ItemsForJungleResinTrade(ItemStack stack, int JungleResin, int items, int maxUses, int exp, float multi) {
            this.stack = stack;
            this.emeraldCount = JungleResin;
            this.itemCount = items;
            this.maxUses = maxUses;
            this.exp = exp;
            this.multiplier = multi;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack cloneStack = new ItemStack((IItemProvider)this.stack.func_77973_b(), this.itemCount);
            cloneStack.func_77982_d(this.stack.func_77978_p());
            return new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN, this.emeraldCount), cloneStack, this.maxUses, this.exp, this.multiplier);
        }
    }

    static class EnchantedItemForJungleResinTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EnchantedItemForJungleResinTrade(Item p_i50535_1_, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedItemForJungleResinTrade(Item sellItem, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack((IItemProvider)sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int lvt_3_1_ = 5 + rand.nextInt(15);
            ItemStack lvt_4_1_ = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)this.sellingStack.func_77973_b()), (int)lvt_3_1_, (boolean)false);
            int lvt_5_1_ = Math.min(this.emeraldCount + lvt_3_1_, 64);
            ItemStack lvt_6_1_ = new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN, lvt_5_1_);
            return new MerchantOffer(lvt_6_1_, lvt_4_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemWithPotionForJungleResinAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack potionStack;
        private final int potionCount;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final Item buyingItem;
        private final int buyingItemCount;
        private final float priceMultiplier;

        public ItemWithPotionForJungleResinAndItemsTrade(Item buyingItem, int buyingItemCount, Item p_i50526_3_, int p_i50526_4_, int emeralds, int maxUses, int xpValue) {
            this.potionStack = new ItemStack((IItemProvider)p_i50526_3_);
            this.emeraldCount = emeralds;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.buyingItem = buyingItem;
            this.buyingItemCount = buyingItemCount;
            this.potionCount = p_i50526_4_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN, this.emeraldCount);
            List lvt_4_1_ = Registry.field_212621_j.func_201756_e().filter(potion -> !potion.func_185170_a().isEmpty() && PotionBrewing.func_222124_a((Potion)potion)).collect(Collectors.toList());
            Potion lvt_5_1_ = (Potion)lvt_4_1_.get(rand.nextInt(lvt_4_1_.size()));
            ItemStack lvt_6_1_ = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this.potionStack.func_77973_b(), this.potionCount), (Potion)lvt_5_1_);
            return new MerchantOffer(lvt_3_1_, new ItemStack((IItemProvider)this.buyingItem, this.buyingItemCount), lvt_6_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForJungleResinAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack buyingItem;
        private final int buyingItemCount;
        private final int emeraldCount;
        private final ItemStack sellingItem;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForJungleResinAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this(buyingItem, buyingItemCount, 1, sellingItem, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForJungleResinAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, int emeraldCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this.buyingItem = new ItemStack(buyingItem);
            this.buyingItemCount = buyingItemCount;
            this.emeraldCount = emeraldCount;
            this.sellingItem = new ItemStack((IItemProvider)sellingItem);
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_JUNGLE_RESIN, this.emeraldCount), new ItemStack((IItemProvider)this.buyingItem.func_77973_b(), this.buyingItemCount), new ItemStack((IItemProvider)this.sellingItem.func_77973_b(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class DesertResinForItemsTrade
    implements VillagerTrades.ITrade {
        private final Item tradeItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public DesertResinForItemsTrade(IItemProvider tradeItemIn, int countIn, int maxUsesIn, int xpValueIn) {
            this.tradeItem = tradeItemIn.func_199767_j();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((IItemProvider)this.tradeItem, this.count);
            return new MerchantOffer(lvt_3_1_, new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForDesertResinTrade
    implements VillagerTrades.ITrade {
        private final ItemStack stack;
        private final int emeraldCount;
        private final int itemCount;
        private final int maxUses;
        private final int exp;
        private final float multiplier;

        public ItemsForDesertResinTrade(Block sellingItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForDesertResinTrade(Item sellingItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack((IItemProvider)sellingItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public ItemsForDesertResinTrade(Item item, int DesertResin, int items, int maxUses, int exp) {
            this(new ItemStack((IItemProvider)item), DesertResin, items, maxUses, exp);
        }

        public ItemsForDesertResinTrade(ItemStack stack, int DesertResin, int items, int maxUses, int exp) {
            this(stack, DesertResin, items, maxUses, exp, 0.05f);
        }

        public ItemsForDesertResinTrade(ItemStack stack, int DesertResin, int items, int maxUses, int exp, float multi) {
            this.stack = stack;
            this.emeraldCount = DesertResin;
            this.itemCount = items;
            this.maxUses = maxUses;
            this.exp = exp;
            this.multiplier = multi;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack cloneStack = new ItemStack((IItemProvider)this.stack.func_77973_b(), this.itemCount);
            cloneStack.func_77982_d(this.stack.func_77978_p());
            return new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN, this.emeraldCount), cloneStack, this.maxUses, this.exp, this.multiplier);
        }
    }

    static class SuspiciousStewForEmeraldTrade
    implements VillagerTrades.ITrade {
        final Effect effect;
        final int duration;
        final int xpValue;
        private final float priceMultiplier;

        public SuspiciousStewForEmeraldTrade(Effect effectIn, int durationIn, int xpValue) {
            this.effect = effectIn;
            this.duration = durationIn;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((IItemProvider)Items.field_222115_pz, 1);
            SuspiciousStewItem.func_220037_a((ItemStack)lvt_3_1_, (Effect)this.effect, (int)this.duration);
            return new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN, 1), lvt_3_1_, 12, this.xpValue, this.priceMultiplier);
        }
    }

    static class EnchantedItemForDesertResinTrade
    implements VillagerTrades.ITrade {
        private final ItemStack sellingStack;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public EnchantedItemForDesertResinTrade(Item p_i50535_1_, int emeraldCount, int maxUses, int xpValue) {
            this(p_i50535_1_, emeraldCount, maxUses, xpValue, 0.05f);
        }

        public EnchantedItemForDesertResinTrade(Item sellItem, int emeraldCount, int maxUses, int xpValue, float priceMultiplier) {
            this.sellingStack = new ItemStack((IItemProvider)sellItem);
            this.emeraldCount = emeraldCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            int lvt_3_1_ = 5 + rand.nextInt(15);
            ItemStack lvt_4_1_ = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack((IItemProvider)this.sellingStack.func_77973_b()), (int)lvt_3_1_, (boolean)false);
            int lvt_5_1_ = Math.min(this.emeraldCount + lvt_3_1_, 64);
            ItemStack lvt_6_1_ = new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN, lvt_5_1_);
            return new MerchantOffer(lvt_6_1_, lvt_4_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemWithPotionForDesertResinAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack potionStack;
        private final int potionCount;
        private final int emeraldCount;
        private final int maxUses;
        private final int xpValue;
        private final Item buyingItem;
        private final int buyingItemCount;
        private final float priceMultiplier;

        public ItemWithPotionForDesertResinAndItemsTrade(Item buyingItem, int buyingItemCount, Item p_i50526_3_, int p_i50526_4_, int emeralds, int maxUses, int xpValue) {
            this.potionStack = new ItemStack((IItemProvider)p_i50526_3_);
            this.emeraldCount = emeralds;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.buyingItem = buyingItem;
            this.buyingItemCount = buyingItemCount;
            this.potionCount = p_i50526_4_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack lvt_3_1_ = new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN, this.emeraldCount);
            List lvt_4_1_ = Registry.field_212621_j.func_201756_e().filter(potion -> !potion.func_185170_a().isEmpty() && PotionBrewing.func_222124_a((Potion)potion)).collect(Collectors.toList());
            Potion lvt_5_1_ = (Potion)lvt_4_1_.get(rand.nextInt(lvt_4_1_.size()));
            ItemStack lvt_6_1_ = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)this.potionStack.func_77973_b(), this.potionCount), (Potion)lvt_5_1_);
            return new MerchantOffer(lvt_3_1_, new ItemStack((IItemProvider)this.buyingItem, this.buyingItemCount), lvt_6_1_, this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    static class ItemsForDesertResinAndItemsTrade
    implements VillagerTrades.ITrade {
        private final ItemStack buyingItem;
        private final int buyingItemCount;
        private final int emeraldCount;
        private final ItemStack sellingItem;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public ItemsForDesertResinAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this(buyingItem, buyingItemCount, 1, sellingItem, sellingItemCount, maxUses, xpValue);
        }

        public ItemsForDesertResinAndItemsTrade(IItemProvider buyingItem, int buyingItemCount, int emeraldCount, Item sellingItem, int sellingItemCount, int maxUses, int xpValue) {
            this.buyingItem = new ItemStack(buyingItem);
            this.buyingItemCount = buyingItemCount;
            this.emeraldCount = emeraldCount;
            this.sellingItem = new ItemStack((IItemProvider)sellingItem);
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)IafItemRegistry.MYRMEX_DESERT_RESIN, this.emeraldCount), new ItemStack((IItemProvider)this.buyingItem.func_77973_b(), this.buyingItemCount), new ItemStack((IItemProvider)this.sellingItem.func_77973_b(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }
}

