/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MyrmexHive {
    private final List<BlockPos> foodRooms = Lists.newArrayList();
    private final List<BlockPos> babyRooms = Lists.newArrayList();
    private final List<BlockPos> miscRooms = Lists.newArrayList();
    private final List<BlockPos> allRooms = Lists.newArrayList();
    private final Map<BlockPos, Direction> entrances = Maps.newHashMap();
    private final Map<BlockPos, Direction> entranceBottoms = Maps.newHashMap();
    private final Map<UUID, Integer> playerReputation = Maps.newHashMap();
    private final List<HiveAggressor> villageAgressors = Lists.newArrayList();
    private final List<UUID> myrmexList = Lists.newArrayList();
    public UUID hiveUUID;
    public String colonyName = "";
    public boolean reproduces = true;
    public boolean hasOwner = false;
    public UUID ownerUUID = null;
    private World world;
    private BlockPos centerHelper = BlockPos.field_177992_a;
    private BlockPos center = BlockPos.field_177992_a;
    private int villageRadius;
    private int lastAddDoorTimestamp;
    private int tickCounter;
    private int numMyrmex;
    private int noBreedTicks;
    private int wanderRadius = 16;

    public MyrmexHive() {
        this.hiveUUID = UUID.randomUUID();
    }

    public MyrmexHive(World worldIn) {
        this.world = worldIn;
        this.hiveUUID = UUID.randomUUID();
    }

    public MyrmexHive(World worldIn, BlockPos center, int radius) {
        this.world = worldIn;
        this.center = center;
        this.villageRadius = radius;
        this.hiveUUID = UUID.randomUUID();
    }

    public static BlockPos getGroundedPos(IWorld world, BlockPos pos) {
        BlockPos current = pos;
        while (world.func_175623_d(current.func_177977_b()) && current.func_177956_o() > 0) {
            current = current.func_177977_b();
        }
        return current;
    }

    public static MyrmexHive fromNBT(CompoundNBT hive) {
        MyrmexHive hive1 = new MyrmexHive();
        hive1.readVillageDataFromNBT(hive);
        return hive1;
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        this.writeVillageDataToNBT(tag);
        return tag;
    }

    public void setWorld(World worldIn) {
        this.world = worldIn;
    }

    public void tick(int tickCounterIn, World world) {
        ++this.tickCounter;
        this.removeDeadAndOldAgressors();
        if (this.tickCounter % 20 == 0) {
            this.updateNumMyrmex(world);
        }
    }

    private void updateNumMyrmex(World world) {
        this.numMyrmex = this.myrmexList.size();
        if (this.numMyrmex == 0) {
            this.playerReputation.clear();
        }
    }

    @Nullable
    public EntityMyrmexQueen getQueen() {
        ArrayList<EntityMyrmexQueen> ourQueens = new ArrayList<EntityMyrmexQueen>();
        if (!this.world.field_72995_K) {
            ServerWorld serverWorld = this.world.func_73046_m().func_71218_a(this.world.func_234923_W_());
            List allQueens = serverWorld.func_217482_a((EntityType)IafEntityRegistry.MYRMEX_QUEEN.get(), EntityPredicates.field_180132_d);
            for (Entity queen : allQueens) {
                if (!(queen instanceof EntityMyrmexQueen) || !((EntityMyrmexQueen)queen).getHive().equals(this)) continue;
                ourQueens.add((EntityMyrmexQueen)queen);
            }
        }
        return ourQueens.isEmpty() ? null : (EntityMyrmexQueen)ourQueens.get(0);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public BlockPos getCenterGround() {
        return MyrmexHive.getGroundedPos((IWorld)this.world, this.center);
    }

    public int getVillageRadius() {
        return this.villageRadius;
    }

    public int getNumMyrmex() {
        return this.numMyrmex;
    }

    public int getWanderRadius() {
        return this.wanderRadius;
    }

    public void setWanderRadius(int wanderRadius) {
        this.wanderRadius = Math.min(wanderRadius, IafConfig.myrmexMaximumWanderRadius);
    }

    public boolean isBlockPosWithinSqVillageRadius(BlockPos pos) {
        return this.center.func_177951_i((Vector3i)pos) < (double)(this.villageRadius * this.villageRadius);
    }

    public boolean isAnnihilated() {
        return false;
    }

    public void addOrRenewAgressor(LivingEntity LivingEntityIn, int agressiveLevel) {
        for (HiveAggressor hive$villageaggressor : this.villageAgressors) {
            if (hive$villageaggressor.agressor != LivingEntityIn) continue;
            hive$villageaggressor.agressionTime = this.tickCounter;
            return;
        }
        this.villageAgressors.add(new HiveAggressor(LivingEntityIn, this.tickCounter, agressiveLevel));
    }

    @Nullable
    public LivingEntity findNearestVillageAggressor(LivingEntity LivingEntityIn) {
        double d0 = Double.MAX_VALUE;
        int previousAgressionLevel = 0;
        HiveAggressor hive$villageaggressor = null;
        for (int i = 0; i < this.villageAgressors.size(); ++i) {
            HiveAggressor hive$villageaggressor1 = this.villageAgressors.get(i);
            double d1 = hive$villageaggressor1.agressor.func_70068_e((Entity)LivingEntityIn);
            int agressionLevel = hive$villageaggressor1.agressionLevel;
            if (d1 <= d0 || agressionLevel > previousAgressionLevel) {
                hive$villageaggressor = hive$villageaggressor1;
                d0 = d1;
            }
            previousAgressionLevel = agressionLevel;
        }
        return hive$villageaggressor == null ? null : hive$villageaggressor.agressor;
    }

    public PlayerEntity getNearestTargetPlayer(LivingEntity villageDefender, World world) {
        double d0 = Double.MAX_VALUE;
        PlayerEntity PlayerEntity2 = null;
        for (UUID s : this.playerReputation.keySet()) {
            double d1;
            PlayerEntity PlayerEntity1;
            if (!this.isPlayerReputationLowEnoughToFight(s) || (PlayerEntity1 = world.func_217371_b(s)) == null || !((d1 = PlayerEntity1.func_70068_e((Entity)villageDefender)) <= d0)) continue;
            PlayerEntity2 = PlayerEntity1;
            d0 = d1;
        }
        return PlayerEntity2;
    }

    private void removeDeadAndOldAgressors() {
        Iterator<HiveAggressor> iterator = this.villageAgressors.iterator();
        while (iterator.hasNext()) {
            HiveAggressor hive$villageaggressor = iterator.next();
            if (hive$villageaggressor.agressor.func_70089_S() && Math.abs(this.tickCounter - hive$villageaggressor.agressionTime) <= 300) continue;
            iterator.remove();
        }
    }

    public int getPlayerReputation(UUID playerName) {
        Integer integer = this.playerReputation.get(playerName);
        return integer == null ? 0 : integer;
    }

    private UUID findUUID(String name) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return PlayerEntity.func_175147_b((String)name);
        }
        GameProfile profile = this.world.func_73046_m().func_152358_ax().func_152655_a(name);
        return profile == null ? PlayerEntity.func_175147_b((String)name) : profile.getId();
    }

    public int modifyPlayerReputation(UUID playerName, int reputation) {
        int i = this.getPlayerReputation(playerName);
        int j = MathHelper.func_76125_a((int)(i + reputation), (int)0, (int)100);
        if (this.hasOwner && playerName.equals(this.ownerUUID)) {
            j = 100;
        }
        PlayerEntity player = null;
        try {
            player = this.world.func_217371_b(playerName);
        }
        catch (Exception e) {
            IceAndFire.LOGGER.warn("Myrmex Hive could not find player with associated UUID");
        }
        if (player != null) {
            if (j - i != 0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent(j - i >= 0 ? "myrmex.message.raised_reputation" : "myrmex.message.lowered_reputation", new Object[]{Math.abs(j - i), j}), true);
            }
            if (i < 25 && j >= 25) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.peaceful"), false);
            }
            if (i >= 25 && j < 25) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.hostile"), false);
            }
            if (i < 50 && j >= 50) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.trade"), false);
            }
            if (i >= 50 && j < 50) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.no_trade"), false);
            }
            if (i < 75 && j >= 75) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.can_use_staff"), false);
            }
            if (i >= 75 && j < 75) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.cant_use_staff"), false);
            }
        }
        this.playerReputation.put(playerName, j);
        return j;
    }

    public boolean isPlayerReputationTooLowToTrade(UUID uuid) {
        return this.getPlayerReputation(uuid) < 50;
    }

    public boolean canPlayerCommandHive(UUID uuid) {
        return this.getPlayerReputation(uuid) >= 75;
    }

    public boolean isPlayerReputationLowEnoughToFight(UUID uuid) {
        return this.getPlayerReputation(uuid) < 25;
    }

    public void readVillageDataFromNBT(CompoundNBT compound) {
        this.numMyrmex = compound.func_74762_e("PopSize");
        this.reproduces = compound.func_74767_n("Reproduces");
        this.hasOwner = compound.func_74767_n("HasOwner");
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
        this.colonyName = compound.func_74779_i("ColonyName");
        this.villageRadius = compound.func_74762_e("Radius");
        if (compound.func_186855_b("WanderRadius")) {
            this.wanderRadius = compound.func_74762_e("WanderRadius");
        }
        this.lastAddDoorTimestamp = compound.func_74762_e("Stable");
        this.tickCounter = compound.func_74762_e("Tick");
        this.noBreedTicks = compound.func_74762_e("MTick");
        this.center = new BlockPos(compound.func_74762_e("CX"), compound.func_74762_e("CY"), compound.func_74762_e("CZ"));
        this.centerHelper = new BlockPos(compound.func_74762_e("ACX"), compound.func_74762_e("ACY"), compound.func_74762_e("ACZ"));
        ListNBT hiveMembers = compound.func_150295_c("HiveMembers", 10);
        this.myrmexList.clear();
        for (int i = 0; i < hiveMembers.size(); ++i) {
            CompoundNBT CompoundNBT2 = hiveMembers.func_150305_b(i);
            this.myrmexList.add(CompoundNBT2.func_186857_a("MyrmexUUID"));
        }
        ListNBT foodRoomList = compound.func_150295_c("FoodRooms", 10);
        this.foodRooms.clear();
        for (int i = 0; i < foodRoomList.size(); ++i) {
            CompoundNBT CompoundNBT3 = foodRoomList.func_150305_b(i);
            this.foodRooms.add(new BlockPos(CompoundNBT3.func_74762_e("X"), CompoundNBT3.func_74762_e("Y"), CompoundNBT3.func_74762_e("Z")));
        }
        ListNBT babyRoomList = compound.func_150295_c("BabyRooms", 10);
        this.babyRooms.clear();
        for (int i = 0; i < babyRoomList.size(); ++i) {
            CompoundNBT CompoundNBT4 = babyRoomList.func_150305_b(i);
            this.babyRooms.add(new BlockPos(CompoundNBT4.func_74762_e("X"), CompoundNBT4.func_74762_e("Y"), CompoundNBT4.func_74762_e("Z")));
        }
        ListNBT miscRoomList = compound.func_150295_c("MiscRooms", 10);
        this.miscRooms.clear();
        for (int i = 0; i < miscRoomList.size(); ++i) {
            CompoundNBT CompoundNBT5 = miscRoomList.func_150305_b(i);
            this.miscRooms.add(new BlockPos(CompoundNBT5.func_74762_e("X"), CompoundNBT5.func_74762_e("Y"), CompoundNBT5.func_74762_e("Z")));
        }
        ListNBT entrancesList = compound.func_150295_c("Entrances", 10);
        this.entrances.clear();
        for (int i = 0; i < entrancesList.size(); ++i) {
            CompoundNBT CompoundNBT6 = entrancesList.func_150305_b(i);
            this.entrances.put(new BlockPos(CompoundNBT6.func_74762_e("X"), CompoundNBT6.func_74762_e("Y"), CompoundNBT6.func_74762_e("Z")), Direction.func_176731_b((int)CompoundNBT6.func_74762_e("Facing")));
        }
        ListNBT entranceBottomsList = compound.func_150295_c("EntranceBottoms", 10);
        this.entranceBottoms.clear();
        for (int i = 0; i < entranceBottomsList.size(); ++i) {
            CompoundNBT CompoundNBT7 = entranceBottomsList.func_150305_b(i);
            this.entranceBottoms.put(new BlockPos(CompoundNBT7.func_74762_e("X"), CompoundNBT7.func_74762_e("Y"), CompoundNBT7.func_74762_e("Z")), Direction.func_176731_b((int)CompoundNBT7.func_74762_e("Facing")));
        }
        this.hiveUUID = compound.func_186857_a("HiveUUID");
        ListNBT nbttaglist1 = compound.func_150295_c("Players", 10);
        this.playerReputation.clear();
        for (int j = 0; j < nbttaglist1.size(); ++j) {
            CompoundNBT CompoundNBT1 = nbttaglist1.func_150305_b(j);
            if (CompoundNBT1.func_186855_b("UUID")) {
                this.playerReputation.put(CompoundNBT1.func_186857_a("UUID"), CompoundNBT1.func_74762_e("S"));
                continue;
            }
            this.playerReputation.put(this.findUUID(CompoundNBT1.func_74779_i("Name")), CompoundNBT1.func_74762_e("S"));
        }
    }

    public void writeVillageDataToNBT(CompoundNBT compound) {
        compound.func_74768_a("PopSize", this.numMyrmex);
        compound.func_74757_a("Reproduces", this.reproduces);
        compound.func_74757_a("HasOwner", this.hasOwner);
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
        compound.func_74778_a("ColonyName", this.colonyName);
        compound.func_74768_a("Radius", this.villageRadius);
        compound.func_74768_a("WanderRadius", this.wanderRadius);
        compound.func_74768_a("Stable", this.lastAddDoorTimestamp);
        compound.func_74768_a("Tick", this.tickCounter);
        compound.func_74768_a("MTick", this.noBreedTicks);
        compound.func_74768_a("CX", this.center.func_177958_n());
        compound.func_74768_a("CY", this.center.func_177956_o());
        compound.func_74768_a("CZ", this.center.func_177952_p());
        compound.func_74768_a("ACX", this.centerHelper.func_177958_n());
        compound.func_74768_a("ACY", this.centerHelper.func_177956_o());
        compound.func_74768_a("ACZ", this.centerHelper.func_177952_p());
        ListNBT hiveMembers = new ListNBT();
        for (UUID uUID : this.myrmexList) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_186854_a("MyrmexUUID", uUID);
            hiveMembers.add((Object)compoundNBT);
        }
        compound.func_218657_a("HiveMembers", (INBT)hiveMembers);
        ListNBT foodRoomList = new ListNBT();
        for (BlockPos blockPos : this.foodRooms) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("X", blockPos.func_177958_n());
            compoundNBT.func_74768_a("Y", blockPos.func_177956_o());
            compoundNBT.func_74768_a("Z", blockPos.func_177952_p());
            foodRoomList.add((Object)compoundNBT);
        }
        compound.func_218657_a("FoodRooms", (INBT)foodRoomList);
        ListNBT listNBT = new ListNBT();
        for (BlockPos blockPos : this.babyRooms) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("X", blockPos.func_177958_n());
            compoundNBT.func_74768_a("Y", blockPos.func_177956_o());
            compoundNBT.func_74768_a("Z", blockPos.func_177952_p());
            listNBT.add((Object)compoundNBT);
        }
        compound.func_218657_a("BabyRooms", (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (BlockPos blockPos : this.miscRooms) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("X", blockPos.func_177958_n());
            compoundNBT.func_74768_a("Y", blockPos.func_177956_o());
            compoundNBT.func_74768_a("Z", blockPos.func_177952_p());
            listNBT2.add((Object)compoundNBT);
        }
        compound.func_218657_a("MiscRooms", (INBT)listNBT2);
        ListNBT listNBT3 = new ListNBT();
        for (Map.Entry<BlockPos, Direction> entry : this.entrances.entrySet()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("X", entry.getKey().func_177958_n());
            compoundNBT.func_74768_a("Y", entry.getKey().func_177956_o());
            compoundNBT.func_74768_a("Z", entry.getKey().func_177952_p());
            compoundNBT.func_74768_a("Facing", entry.getValue().func_176736_b());
            listNBT3.add((Object)compoundNBT);
        }
        compound.func_218657_a("Entrances", (INBT)listNBT3);
        ListNBT listNBT4 = new ListNBT();
        for (Map.Entry<BlockPos, Direction> entry : this.entranceBottoms.entrySet()) {
            CompoundNBT CompoundNBT7 = new CompoundNBT();
            CompoundNBT7.func_74768_a("X", entry.getKey().func_177958_n());
            CompoundNBT7.func_74768_a("Y", entry.getKey().func_177956_o());
            CompoundNBT7.func_74768_a("Z", entry.getKey().func_177952_p());
            CompoundNBT7.func_74768_a("Facing", entry.getValue().func_176736_b());
            listNBT4.add((Object)CompoundNBT7);
        }
        compound.func_218657_a("EntranceBottoms", (INBT)listNBT4);
        compound.func_186854_a("HiveUUID", this.hiveUUID);
        ListNBT listNBT5 = new ListNBT();
        for (UUID s : this.playerReputation.keySet()) {
            CompoundNBT CompoundNBT1 = new CompoundNBT();
            try {
                CompoundNBT1.func_186854_a("UUID", s);
                CompoundNBT1.func_74768_a("S", this.playerReputation.get(s).intValue());
                listNBT5.add((Object)CompoundNBT1);
            }
            catch (RuntimeException runtimeException) {}
        }
        compound.func_218657_a("Players", (INBT)listNBT5);
    }

    public void addRoom(BlockPos center, WorldGenMyrmexHive.RoomType roomType) {
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD && !this.foodRooms.contains(center)) {
            this.foodRooms.add(center);
        } else if (roomType == WorldGenMyrmexHive.RoomType.NURSERY && !this.babyRooms.contains(center)) {
            this.babyRooms.add(center);
        } else if (!this.miscRooms.contains(center) && !this.miscRooms.contains(center)) {
            this.miscRooms.add(center);
        }
        this.allRooms.add(center);
    }

    public void addRoomWithMessage(PlayerEntity player, BlockPos center, WorldGenMyrmexHive.RoomType roomType) {
        ArrayList<BlockPos> allCurrentRooms = new ArrayList<BlockPos>(this.getAllRooms());
        allCurrentRooms.addAll(this.getEntrances().keySet());
        allCurrentRooms.addAll(this.getEntranceBottoms().keySet());
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD) {
            if (!this.foodRooms.contains(center) && !allCurrentRooms.contains(center)) {
                this.foodRooms.add(center);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.added_food_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            }
        } else if (roomType == WorldGenMyrmexHive.RoomType.NURSERY) {
            if (!this.babyRooms.contains(center) && !allCurrentRooms.contains(center)) {
                this.babyRooms.add(center);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.added_nursery_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            }
        } else if (!this.miscRooms.contains(center) && !allCurrentRooms.contains(center)) {
            this.miscRooms.add(center);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.added_misc_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        }
    }

    public void addEnteranceWithMessage(PlayerEntity player, boolean bottom, BlockPos center, Direction facing) {
        ArrayList<BlockPos> allCurrentRooms = new ArrayList<BlockPos>(this.getAllRooms());
        allCurrentRooms.addAll(this.getEntrances().keySet());
        allCurrentRooms.addAll(this.getEntranceBottoms().keySet());
        if (bottom) {
            if (allCurrentRooms.contains(center)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            } else {
                this.getEntranceBottoms().put(center, facing);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.added_enterance_bottom", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
            }
        } else if (allCurrentRooms.contains(center)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.dupe_room", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        } else {
            this.getEntrances().put(center, facing);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("myrmex.message.added_enterance_surface", new Object[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p()}), false);
        }
    }

    public List<BlockPos> getRooms(WorldGenMyrmexHive.RoomType roomType) {
        if (roomType == WorldGenMyrmexHive.RoomType.FOOD) {
            return this.foodRooms;
        }
        if (roomType == WorldGenMyrmexHive.RoomType.NURSERY) {
            return this.babyRooms;
        }
        return this.miscRooms;
    }

    public List<BlockPos> getAllRooms() {
        this.allRooms.clear();
        this.allRooms.add(this.center);
        this.allRooms.addAll(this.foodRooms);
        this.allRooms.addAll(this.babyRooms);
        this.allRooms.addAll(this.miscRooms);
        return this.allRooms;
    }

    public BlockPos getRandomRoom(Random random, BlockPos returnPos) {
        List<BlockPos> rooms = this.getAllRooms();
        return rooms.isEmpty() ? returnPos : rooms.get(random.nextInt(Math.max(rooms.size() - 1, 1)));
    }

    public BlockPos getRandomRoom(WorldGenMyrmexHive.RoomType roomType, Random random, BlockPos returnPos) {
        List<BlockPos> rooms = this.getRooms(roomType);
        return rooms.isEmpty() ? returnPos : rooms.get(random.nextInt(Math.max(rooms.size() - 1, 1)));
    }

    public BlockPos getClosestEntranceToEntity(Entity entity, Random random, boolean randomize) {
        Map.Entry<BlockPos, Direction> closest = this.getClosestEntrance(entity);
        if (closest != null) {
            if (randomize) {
                BlockPos pos = closest.getKey().func_177967_a(closest.getValue(), random.nextInt(7) + 7).func_177981_b(4);
                return pos.func_177982_a(10 - random.nextInt(20), 0, 10 - random.nextInt(20));
            }
            return closest.getKey().func_177967_a(closest.getValue(), 3);
        }
        return entity.func_233580_cy_();
    }

    public BlockPos getClosestEntranceBottomToEntity(Entity entity, Random random) {
        Map.Entry<BlockPos, Direction> closest = null;
        for (Map.Entry<BlockPos, Direction> entry : this.entranceBottoms.entrySet()) {
            if (closest != null && !(((BlockPos)closest.getKey()).func_218140_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), false) > entry.getKey().func_218140_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), false))) continue;
            closest = entry;
        }
        return closest != null ? (BlockPos)closest.getKey() : entity.func_233580_cy_();
    }

    public PlayerEntity getOwner(World world) {
        if (this.hasOwner) {
            return world.func_217371_b(this.ownerUUID);
        }
        return null;
    }

    public Map<BlockPos, Direction> getEntrances() {
        return this.entrances;
    }

    public Map<BlockPos, Direction> getEntranceBottoms() {
        return this.entranceBottoms;
    }

    private Map.Entry<BlockPos, Direction> getClosestEntrance(Entity entity) {
        Map.Entry<BlockPos, Direction> closest = null;
        for (Map.Entry<BlockPos, Direction> entry : this.entrances.entrySet()) {
            if (closest != null && !(((BlockPos)closest.getKey()).func_218140_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), false) > entry.getKey().func_218140_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), false))) continue;
            closest = entry;
        }
        return closest;
    }

    public void setDefaultPlayerReputation(int defaultReputation) {
        for (UUID s : this.playerReputation.keySet()) {
            this.modifyPlayerReputation(s, defaultReputation);
        }
    }

    public boolean repopulate() {
        int roomCount = this.getAllRooms().size();
        return this.numMyrmex < Math.min(IafConfig.myrmexColonySize, roomCount * 9) && this.reproduces;
    }

    public void addMyrmex(EntityMyrmexBase myrmex) {
        if (!this.myrmexList.contains(myrmex.func_110124_au())) {
            this.myrmexList.add(myrmex.func_110124_au());
        }
    }

    public void removeRoom(BlockPos pos) {
        this.foodRooms.remove(pos);
        this.miscRooms.remove(pos);
        this.babyRooms.remove(pos);
        this.allRooms.remove(pos);
        this.getEntrances().remove(pos);
        this.getEntranceBottoms().remove(pos);
    }

    public String toString() {
        return "MyrmexHive(x=" + this.center.func_177958_n() + ",y=" + this.center.func_177956_o() + ",z=" + this.center.func_177952_p() + "), population=" + this.getNumMyrmex() + "\nUUID: " + this.hiveUUID;
    }

    public boolean equals(MyrmexHive hive) {
        return this.hiveUUID.equals(hive.hiveUUID);
    }

    class HiveAggressor {
        public LivingEntity agressor;
        public int agressionTime;
        public int agressionLevel;

        HiveAggressor(LivingEntity agressorIn, int agressionTimeIn, int agressionLevel) {
            this.agressor = agressorIn;
            this.agressionTime = agressionTimeIn;
            this.agressionLevel = agressionLevel;
        }
    }
}

