/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;

public interface IHasCustomizableAttributes {
    public static final Map<EntityType<? extends LivingEntity>, AttributeModifierMap> ATTRIBUTE_MODIFIER_MAP = new HashMap<EntityType<? extends LivingEntity>, AttributeModifierMap>();

    public static <T extends LivingEntity, M extends LivingEntity> void applyAttributesForEntity(EntityType<T> type, M entity) {
        entity.field_110155_d = new AttributeModifierManager(IHasCustomizableAttributes.getAttributesForEntity(type, entity));
        entity.func_70606_j(entity.func_110138_aP());
    }

    public static <T extends LivingEntity, M extends LivingEntity> AttributeModifierMap getAttributesForEntity(EntityType<T> type, M entity) {
        if (!IafConfig.allowAttributeOverriding) {
            return GlobalEntityTypeAttributes.func_233835_a_(type);
        }
        if (ATTRIBUTE_MODIFIER_MAP.containsKey(type)) {
            return ATTRIBUTE_MODIFIER_MAP.get(type);
        }
        AttributeModifierMap originalMap = GlobalEntityTypeAttributes.func_233835_a_(type);
        AttributeModifierMap.MutableAttribute originalMutable = new AttributeModifierMap.MutableAttribute(originalMap);
        originalMutable.combine(((IHasCustomizableAttributes)entity).getAttributes());
        AttributeModifierMap newMap = originalMutable.func_233813_a_();
        ATTRIBUTE_MODIFIER_MAP.put(type, newMap);
        return newMap;
    }

    public AttributeModifierMap.MutableAttribute getAttributes();
}

