/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HomePosition {
    int x;
    int y;
    int z;
    BlockPos pos;
    String dimension;

    public HomePosition(CompoundNBT compound) {
        this.read(compound);
    }

    public HomePosition(CompoundNBT compound, World world) {
        this.read(compound, world);
    }

    public HomePosition(BlockPos pos, World world) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
    }

    public HomePosition(int x, int y, int z, World world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.pos = new BlockPos(x, y, z);
        this.dimension = DragonUtils.getDimensionName(world);
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public String getDimension() {
        return this.dimension == null ? "" : this.dimension;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("HomeAreaX", this.x);
        compound.func_74768_a("HomeAreaY", this.y);
        compound.func_74768_a("HomeAreaZ", this.z);
        if (this.dimension != null) {
            compound.func_74778_a("HomeDimension", this.dimension);
        }
        return compound;
    }

    public HomePosition read(CompoundNBT compound, World world) {
        this.read(compound);
        if (this.dimension == null) {
            this.dimension = DragonUtils.getDimensionName(world);
        }
        return this;
    }

    public HomePosition read(CompoundNBT compound) {
        if (compound.func_74764_b("HomeAreaX")) {
            this.x = compound.func_74762_e("HomeAreaX");
        }
        if (compound.func_74764_b("HomeAreaY")) {
            this.y = compound.func_74762_e("HomeAreaY");
        }
        if (compound.func_74764_b("HomeAreaZ")) {
            this.z = compound.func_74762_e("HomeAreaZ");
        }
        this.pos = new BlockPos(this.x, this.y, this.z);
        if (compound.func_74764_b("HomeDimension")) {
            this.dimension = compound.func_74779_i("HomeDimension");
        }
        return this;
    }
}

