/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockLaunchExplosion
extends Explosion {
    private final float size;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final Explosion.Mode mode;

    public BlockLaunchExplosion(World world, MobEntity entity, double x, double y, double z, float size) {
        this(world, entity, x, y, z, size, Explosion.Mode.DESTROY);
    }

    public BlockLaunchExplosion(World world, MobEntity entity, double x, double y, double z, float size, Explosion.Mode mode) {
        this(world, entity, null, x, y, z, size, mode);
    }

    public BlockLaunchExplosion(World world, MobEntity entity, DamageSource source, double x, double y, double z, float size, Explosion.Mode mode) {
        super(world, (Entity)entity, source, null, x, y, z, size, false, mode);
        this.world = world;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    private static void handleExplosionDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)dropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!stack.func_190926_b()) continue;
            return;
        }
        dropPositionArray.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean flag;
        if (this.world.field_72995_K) {
            this.world.func_184134_a(this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.Mode.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.func_180343_e(), this.world.field_73012_v);
            for (BlockPos blockpos : this.func_180343_e()) {
                BlockState blockstate = this.world.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)this.world, blockpos)) continue;
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.world.func_217381_Z().func_76320_a("explosion_blocks");
                Vector3d Vector3d2 = new Vector3d(this.x, this.y, this.z);
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(EntityType.field_200809_w, this.world);
                fallingBlockEntity.func_184530_a(blockpos1);
                fallingBlockEntity.func_70107_b((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5);
                double d5 = fallingBlockEntity.func_226277_ct_() - this.x;
                double d7 = fallingBlockEntity.func_226280_cw_() - this.y;
                double d9 = fallingBlockEntity.func_226281_cx_() - this.z;
                float f3 = this.size * 2.0f;
                double d12 = MathHelper.func_76133_a((double)fallingBlockEntity.func_195048_a(Vector3d2)) / f3;
                double d14 = BlockLaunchExplosion.func_222259_a((Vector3d)Vector3d2, (Entity)fallingBlockEntity);
                double d11 = (1.0 - d12) * d14;
                fallingBlockEntity.func_213317_d(fallingBlockEntity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
                this.world.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
    }
}

