/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;

public class FrozenProperties {
    private static final String FROZEN_DATA = "FrozenDataIaf";
    private static final String FROZEN_BOOL = "IsFrozen";
    private static final String FROZEN_TIME = "TicksUntilUnfrozen";
    private static final Random rand = new Random();

    private static CompoundNBT getOrCreateFrozenData(LivingEntity entity) {
        return FrozenProperties.getOrCreateFrozenData(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static CompoundNBT getOrCreateFrozenData(CompoundNBT entityData) {
        if (entityData.func_150297_b(FROZEN_DATA, 10)) {
            return (CompoundNBT)entityData.func_74781_a(FROZEN_DATA);
        }
        return FrozenProperties.createDefaultData();
    }

    private static CompoundNBT createDefaultData() {
        CompoundNBT nbt = new CompoundNBT();
        return FrozenProperties.clearFrozenStatus(nbt);
    }

    private static CompoundNBT clearFrozenStatus(CompoundNBT nbt, LivingEntity entity, boolean breakIce) {
        if (breakIce) {
            for (int i = 0; i < 15; ++i) {
                entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, IafBlockRegistry.DRAGON_ICE.func_176223_P()), entity.func_226277_ct_() + (rand.nextDouble() - 0.5) * (double)entity.func_213311_cf(), entity.func_226278_cu_() + rand.nextDouble() * (double)entity.func_213302_cg(), entity.func_226281_cx_() + (rand.nextDouble() - 0.5) * (double)entity.func_213311_cf(), 0.0, 0.0, 0.0);
            }
            entity.func_184185_a(SoundEvents.field_187561_bM, 3.0f, 1.0f);
        }
        return FrozenProperties.clearFrozenStatus(nbt);
    }

    private static CompoundNBT clearFrozenStatus(CompoundNBT nbt) {
        nbt.func_74768_a(FROZEN_TIME, 0);
        nbt.func_74757_a(FROZEN_BOOL, false);
        return nbt;
    }

    public static boolean isFrozen(LivingEntity entity) {
        CompoundNBT nbt;
        if (!(entity instanceof EntityIceDragon) && (nbt = FrozenProperties.getOrCreateFrozenData(entity)).func_74764_b(FROZEN_BOOL)) {
            return nbt.func_74767_n(FROZEN_BOOL);
        }
        return false;
    }

    public static int ticksUntilUnfrozen(LivingEntity entity) {
        CompoundNBT nbt;
        if (!(entity instanceof EntityIceDragon) && (nbt = FrozenProperties.getOrCreateFrozenData(entity)).func_74764_b(FROZEN_TIME)) {
            return nbt.func_74762_e(FROZEN_TIME);
        }
        return 0;
    }

    public static void setFrozenFor(LivingEntity entity, int duration) {
        if (!(entity instanceof EntityIceDragon)) {
            CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
            CompoundNBT frozenData = FrozenProperties.getOrCreateFrozenData(entityData);
            if (!frozenData.func_74767_n(FROZEN_BOOL)) {
                entity.func_184185_a(SoundEvents.field_187567_bP, 1.0f, 1.0f);
            }
            frozenData.func_74768_a(FROZEN_TIME, duration);
            frozenData.func_74757_a(FROZEN_BOOL, true);
            entityData.func_218657_a(FROZEN_DATA, (INBT)frozenData);
            FrozenProperties.updateData(entity, entityData);
        }
    }

    public static void updateData(LivingEntity entity) {
        FrozenProperties.updateData(entity, CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundNBT nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundNBT)nbt);
        if (!entity.field_70170_p.func_201670_d()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.func_145782_y()));
        }
    }

    public static void tickFrozenEntity(LivingEntity entity) {
        CompoundNBT entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        CompoundNBT frozenData = FrozenProperties.getOrCreateFrozenData(entityData);
        if (entity instanceof EntityIceDragon) {
            frozenData.func_74757_a(FROZEN_BOOL, false);
        }
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        if (frozenData.func_74764_b(FROZEN_TIME)) {
            int frozenTime = frozenData.func_74762_e(FROZEN_TIME);
            if (entity.func_70027_ad()) {
                FrozenProperties.clearFrozenStatus(frozenData, entity, true);
                entity.func_70066_B();
            } else if (entity.field_70725_aQ > 0) {
                FrozenProperties.clearFrozenStatus(frozenData, entity, false);
            } else if (frozenTime > 0) {
                frozenData.func_74768_a(FROZEN_TIME, --frozenTime);
            } else {
                FrozenProperties.clearFrozenStatus(frozenData, entity, true);
            }
        }
        entityData.func_218657_a(FROZEN_DATA, (INBT)frozenData);
        FrozenProperties.updateData(entity, entityData);
    }
}

