/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.message.MessageSpawnParticleAt;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class IafDragonLogic {
    private final EntityDragonBase dragon;

    public IafDragonLogic(EntityDragonBase dragon) {
        this.dragon = dragon;
    }

    public void updateDragonServer() {
        PlayerEntity ridingPlayer = this.dragon.getRidingPlayer();
        if (ridingPlayer != null) {
            if (this.dragon.isGoingUp()) {
                if (!this.dragon.isFlying() && !this.dragon.isHovering()) {
                    this.dragon.spacebarTicks += 2;
                }
            } else if (this.dragon.isDismounting() && (this.dragon.isFlying() || this.dragon.isHovering())) {
                this.dragon.func_213317_d(this.dragon.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
                this.dragon.setFlying(false);
                this.dragon.setHovering(false);
            }
        }
        if (!this.dragon.isDismounting() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.func_213317_d(this.dragon.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
        }
        if (this.dragon.isStriking() && this.dragon.func_184179_bs() != null && this.dragon.getDragonStage() > 1) {
            this.dragon.setBreathingFire(true);
            this.dragon.riderShootFire(this.dragon.func_184179_bs());
            this.dragon.fireStopTicks = 10;
        }
        if (this.dragon.isAttacking() && this.dragon.func_184179_bs() != null && this.dragon.func_184179_bs() instanceof PlayerEntity) {
            LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this.dragon, (LivingEntity)((PlayerEntity)this.dragon.func_184179_bs()), (double)this.dragon.getDragonStage() + (this.dragon.func_174813_aQ().field_72336_d - this.dragon.func_174813_aQ().field_72340_a));
            if (this.dragon.getAnimation() != EntityDragonBase.ANIMATION_BITE) {
                this.dragon.setAnimation(EntityDragonBase.ANIMATION_BITE);
            }
            if (target != null && !DragonUtils.hasSameOwner(this.dragon, (Entity)target)) {
                this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.func_110148_a(Attributes.field_233823_f_).func_111126_e());
            }
        }
        if (this.dragon.func_184179_bs() != null && this.dragon.func_184179_bs().func_225608_bj_()) {
            if (this.dragon.func_184179_bs() instanceof LivingEntity) {
                MiscProperties.setDismountedDragon((LivingEntity)this.dragon.func_184179_bs(), true);
            }
            this.dragon.func_184179_bs().func_184210_p();
        }
        if (this.dragon.isFlying()) {
            if (!this.dragon.isHovering() && this.dragon.func_184179_bs() != null && !this.dragon.func_233570_aj_() && Math.max(Math.abs(this.dragon.func_213322_ci().func_82615_a()), Math.abs(this.dragon.func_213322_ci().func_82616_c())) < (double)0.1f) {
                this.dragon.setHovering(true);
                this.dragon.setFlying(false);
            }
        } else if (this.dragon.isHovering() && this.dragon.func_184179_bs() != null && !this.dragon.func_233570_aj_() && Math.max(Math.abs(this.dragon.func_213322_ci().func_82615_a()), Math.abs(this.dragon.func_213322_ci().func_82616_c())) > (double)0.1f) {
            this.dragon.setFlying(true);
            this.dragon.usingGroundAttack = false;
            this.dragon.setHovering(false);
        }
        if (this.dragon.spacebarTicks > 0) {
            --this.dragon.spacebarTicks;
        }
        if (this.dragon.spacebarTicks > 20 && this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q()) && !this.dragon.isFlying() && !this.dragon.isHovering()) {
            this.dragon.setHovering(true);
        }
        if (this.dragon.isOverAir() && !this.dragon.func_184218_aH()) {
            double ydist = this.dragon.field_70167_r - this.dragon.func_226278_cu_();
            if (!this.dragon.isHovering()) {
                this.dragon.incrementDragonPitch((float)ydist * 10.0f);
            }
            this.dragon.setDragonPitch(MathHelper.func_76131_a((float)this.dragon.getDragonPitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            float planeDist = (float)((Math.abs(this.dragon.func_213322_ci().field_72450_a) + Math.abs(this.dragon.func_213322_ci().field_72449_c)) * 6.0);
            if (this.dragon.getDragonPitch() > 2.0f) {
                this.dragon.decrementDragonPitch(planeDist * Math.abs(this.dragon.getDragonPitch()) / 90.0f);
            }
            if (this.dragon.getDragonPitch() < -2.0f) {
                this.dragon.incrementDragonPitch(planeDist * Math.abs(this.dragon.getDragonPitch()) / 90.0f);
            }
            if (this.dragon.getDragonPitch() > 2.0f) {
                this.dragon.decrementDragonPitch(1.0f);
            } else if (this.dragon.getDragonPitch() < -2.0f) {
                this.dragon.incrementDragonPitch(1.0f);
            }
            if (this.dragon.getDragonPitch() < -45.0f && planeDist < 3.0f && this.dragon.isFlying() && !this.dragon.isHovering()) {
                this.dragon.setHovering(true);
            }
        } else {
            this.dragon.setDragonPitch(0.0f);
        }
        if (this.dragon.lookingForRoostAIFlag && this.dragon.func_70643_av() != null || this.dragon.func_70608_bn()) {
            this.dragon.lookingForRoostAIFlag = false;
        }
        if (IafConfig.doDragonsSleep && !this.dragon.func_70608_bn() && !this.dragon.isTimeToWake() && this.dragon.func_184188_bt().isEmpty() && this.dragon.getCommand() != 2) {
            if (this.dragon.hasHomePosition && this.dragon.func_213384_dI() != null && DragonUtils.isInHomeDimension(this.dragon) && this.dragon.getDistanceSquared(Vector3d.func_237489_a_((Vector3i)this.dragon.func_213384_dI())) > this.dragon.func_213311_cf() * 10.0f && this.dragon.getCommand() != 2 && this.dragon.getCommand() != 1) {
                this.dragon.lookingForRoostAIFlag = true;
            } else {
                this.dragon.lookingForRoostAIFlag = false;
                if (!this.dragon.func_70090_H() && this.dragon.func_233570_aj_() && !this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.func_70638_az() == null) {
                    this.dragon.func_233686_v_(true);
                }
            }
        } else {
            this.dragon.lookingForRoostAIFlag = false;
        }
        if (this.dragon.func_70608_bn() && (this.dragon.isFlying() || this.dragon.isHovering() || this.dragon.func_70090_H() || this.dragon.field_70170_p.func_175710_j(this.dragon.func_233580_cy_()) && this.dragon.isTimeToWake() && !this.dragon.func_70909_n() || this.dragon.isTimeToWake() && this.dragon.func_70909_n() || this.dragon.func_70638_az() != null || !this.dragon.func_184188_bt().isEmpty())) {
            this.dragon.func_233686_v_(false);
        }
        if (this.dragon.func_233685_eM_() && this.dragon.func_184179_bs() != null) {
            this.dragon.func_233687_w_(false);
        }
        if (this.dragon.func_184207_aI() && !this.dragon.isOverAir() && this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.flyTicks > 40) {
            this.dragon.setFlying(false);
        }
        if (this.dragon.blockBreakCounter <= 0) {
            this.dragon.blockBreakCounter = IafConfig.dragonBreakBlockCooldown;
        }
        this.dragon.updateBurnTarget();
        if (this.dragon.func_233685_eM_()) {
            if (this.dragon.getCommand() != 1 || this.dragon.func_184179_bs() != null) {
                this.dragon.func_233687_w_(false);
            }
        } else if (this.dragon.getCommand() == 1 && this.dragon.func_184179_bs() == null) {
            this.dragon.func_233687_w_(true);
        }
        if (this.dragon.func_233685_eM_()) {
            this.dragon.func_70661_as().func_75499_g();
        }
        if (this.dragon.func_70880_s()) {
            this.dragon.field_70170_p.func_72960_a((Entity)this.dragon, (byte)18);
        }
        this.dragon.ticksStill = (int)this.dragon.field_70169_q == (int)this.dragon.func_226277_ct_() && (int)this.dragon.field_70166_s == (int)this.dragon.func_226281_cx_() ? ++this.dragon.ticksStill : 0;
        if (this.dragon.isTackling() && !this.dragon.isFlying() && this.dragon.func_233570_aj_()) {
            ++this.dragon.tacklingTicks;
            if (this.dragon.tacklingTicks == 40) {
                this.dragon.tacklingTicks = 0;
                this.dragon.setTackling(false);
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.func_70681_au().nextInt(500) == 0 && !this.dragon.isModelDead() && !this.dragon.func_70608_bn()) {
            this.dragon.roar();
        }
        if (this.dragon.isFlying() && this.dragon.func_70638_az() != null) {
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE) {
                this.dragon.setTackling(true);
            }
            if (this.dragon.isTackling() && this.dragon.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0).func_72326_a(this.dragon.func_70638_az().func_174813_aQ())) {
                this.dragon.usingGroundAttack = true;
                this.dragon.randomizeAttacks();
                this.attackTarget((Entity)this.dragon.func_70638_az(), ridingPlayer, this.dragon.getDragonStage() * 3);
                this.dragon.setFlying(false);
                this.dragon.setHovering(false);
            }
        }
        if (this.dragon.isTackling() && (this.dragon.func_70638_az() == null || this.dragon.airAttack != IafDragonAttacks.Air.TACKLE)) {
            this.dragon.setTackling(false);
            this.dragon.randomizeAttacks();
        }
        if (this.dragon.func_184218_aH()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
            this.dragon.func_233686_v_(false);
        }
        if (this.dragon.isFlying() && this.dragon.field_70173_aa % 40 == 0 || this.dragon.isFlying() && this.dragon.func_70608_bn()) {
            this.dragon.func_233686_v_(false);
        }
        if (!this.dragon.canMove()) {
            if (this.dragon.func_70638_az() != null) {
                this.dragon.func_70624_b(null);
            }
            this.dragon.func_70661_as().func_75499_g();
        }
        if (!this.dragon.func_70909_n()) {
            this.dragon.updateCheckPlayer();
        }
        if (this.dragon.isModelDead() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (ridingPlayer == null) {
            if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 1) {
                this.dragon.switchNavigator(1);
            }
        } else if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 2) {
            this.dragon.switchNavigator(2);
        }
        if (!this.dragon.useFlyingPathFinder() && !this.dragon.isHovering() && this.dragon.navigatorType != 0) {
            this.dragon.switchNavigator(0);
        }
        if (!this.dragon.isOverAir() && this.dragon.doesWantToLand() && (this.dragon.isFlying() || this.dragon.isHovering()) && !this.dragon.func_70090_H()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isHovering()) {
            if (this.dragon.isFlying() && this.dragon.flyTicks > 40) {
                this.dragon.setHovering(false);
                this.dragon.setFlying(true);
            }
            ++this.dragon.hoverTicks;
        } else {
            this.dragon.hoverTicks = 0;
        }
        if (this.dragon.isHovering() && !this.dragon.isFlying()) {
            if (this.dragon.func_70608_bn()) {
                this.dragon.setHovering(false);
            }
            if (this.dragon.doesWantToLand() && !this.dragon.func_233570_aj_() && !this.dragon.func_70090_H()) {
                this.dragon.func_213317_d(this.dragon.func_213322_ci().func_72441_c(0.0, -0.25, 0.0));
            } else {
                if ((this.dragon.func_184179_bs() == null || this.dragon.func_184179_bs() instanceof EntityDreadQueen) && !this.dragon.isBeyondHeight()) {
                    double up = this.dragon.func_70090_H() ? 0.12 : 0.08;
                    this.dragon.func_213317_d(this.dragon.func_213322_ci().func_72441_c(0.0, up, 0.0));
                }
                if (this.dragon.hoverTicks > 40) {
                    this.dragon.setHovering(false);
                    this.dragon.setFlying(true);
                    this.dragon.flyHovering = 0;
                    this.dragon.hoverTicks = 0;
                    this.dragon.flyTicks = 0;
                }
            }
        }
        if (this.dragon.func_70608_bn()) {
            this.dragon.func_70661_as().func_75499_g();
        }
        if ((this.dragon.func_233570_aj_() || this.dragon.func_70090_H()) && this.dragon.flyTicks != 0) {
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.isAllowedToTriggerFlight() && this.dragon.isFlying() && this.dragon.doesWantToLand()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(this.dragon.isOverAir());
            if (!this.dragon.isOverAir()) {
                this.dragon.flyTicks = 0;
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.isFlying()) {
            ++this.dragon.flyTicks;
        }
        if ((this.dragon.isHovering() || this.dragon.isFlying()) && this.dragon.func_70608_bn()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (!this.dragon.isFlying() && !this.dragon.isHovering() && (this.dragon.isAllowedToTriggerFlight() || this.dragon.func_226278_cu_() < -1.0) && (this.dragon.func_70681_au().nextInt(this.dragon.getFlightChancePerTick()) == 0 || this.dragon.func_226278_cu_() < -1.0 || this.dragon.func_70638_az() != null && Math.abs(this.dragon.func_70638_az().func_226278_cu_() - this.dragon.func_226278_cu_()) > 5.0 || this.dragon.func_70090_H() && !this.dragon.isIceInWater())) {
            this.dragon.setHovering(true);
            this.dragon.func_233686_v_(false);
            this.dragon.func_233687_w_(false);
            this.dragon.flyHovering = 0;
            this.dragon.hoverTicks = 0;
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.func_70638_az() != null) {
            if (!this.dragon.func_184188_bt().isEmpty() && this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q())) {
                this.dragon.func_70624_b(null);
            }
            if (!DragonUtils.isAlive(this.dragon.func_70638_az())) {
                this.dragon.func_70624_b(null);
            }
        }
        if (!this.dragon.isAgingDisabled()) {
            this.dragon.setAgeInTicks(this.dragon.getAgeInTicks() + 1);
            if (this.dragon.getAgeInTicks() % 24000 == 0) {
                this.dragon.updateAttributes();
                this.dragon.growDragon(0);
            }
        }
        if (this.dragon.field_70173_aa % IafConfig.dragonHungerTickRate == 0 && IafConfig.dragonHungerTickRate > 0 && this.dragon.getHunger() > 0) {
            this.dragon.setHunger(this.dragon.getHunger() - 1);
        }
        if (this.dragon.groundAttack == IafDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            this.dragon.usingGroundAttack = true;
            this.dragon.randomizeAttacks();
            this.dragon.func_184185_a(this.dragon.getBabyFireSound(), 1.0f, 1.0f);
        }
        if (this.dragon.isBreathingFire()) {
            if (this.dragon.func_70608_bn() || this.dragon.isModelDead()) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireTicks = 0;
            }
            if (this.dragon.burningTarget == null && (this.dragon.fireTicks > this.dragon.getDragonStage() * 25 || this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q()) && this.dragon.fireStopTicks <= 0)) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireTicks = 0;
            }
            if (this.dragon.fireStopTicks > 0 && this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q())) {
                --this.dragon.fireStopTicks;
            }
        }
        if (this.dragon.isFlying()) {
            if (this.dragon.func_70638_az() != null && this.dragon.func_174813_aQ().func_72321_a(3.0, 3.0, 3.0).func_72326_a(this.dragon.func_70638_az().func_174813_aQ())) {
                this.dragon.func_70652_k((Entity)this.dragon.func_70638_az());
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && (this.dragon.field_70123_F || this.dragon.func_233570_aj_())) {
                this.dragon.usingGroundAttack = true;
                this.dragon.setFlying(false);
                this.dragon.setHovering(false);
            }
            if (this.dragon.usingGroundAttack) {
                this.dragon.airAttack = IafDragonAttacks.Air.TACKLE;
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && this.dragon.func_70638_az() != null && this.dragon.isTargetBlocked(this.dragon.func_70638_az().func_213303_ch())) {
                this.dragon.randomizeAttacks();
            }
        }
    }

    public void attackTarget(Entity target, PlayerEntity ridingPlayer, float damage) {
        if (ridingPlayer == null) {
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.dragon), damage);
        } else {
            target.func_70097_a(DamageSource.func_188403_a((Entity)this.dragon, (LivingEntity)ridingPlayer), damage);
        }
    }

    public void updateDragonClient() {
        if (!this.dragon.isModelDead()) {
            this.dragon.turn_buffer.calculateChainSwingBuffer(50.0f, 0, 4.0f, (LivingEntity)this.dragon);
            this.dragon.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (LivingEntity)this.dragon);
            if (!this.dragon.func_233570_aj_()) {
                this.dragon.roll_buffer.calculateChainFlapBuffer(55.0f, 1, 2.0f, 0.5f, (LivingEntity)this.dragon);
                this.dragon.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 1.0f, 0.5f, (LivingEntity)this.dragon);
                this.dragon.pitch_buffer_body.calculateChainWaveBuffer(80.0f, 10, 1.0f, 0.5f, (LivingEntity)this.dragon);
            }
        }
        this.dragon.walkCycle = this.dragon.walkCycle < 39 ? ++this.dragon.walkCycle : 0;
        if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 17 || this.dragon.getAnimationTick() == 22 || this.dragon.getAnimationTick() == 28)) {
            this.dragon.spawnGroundEffects();
        }
        this.dragon.legSolver.update(this.dragon, this.dragon.getRenderSize() / 3.0f);
        if (this.dragon.flightCycle == 11) {
            this.dragon.spawnGroundEffects();
        }
        if (this.dragon.isModelDead() && this.dragon.flightCycle != 0) {
            this.dragon.flightCycle = 0;
        }
    }

    public void updateDragonCommon() {
        boolean riding;
        boolean modelDead;
        boolean tackling;
        boolean diving;
        boolean hovering;
        boolean sitting;
        boolean sleeping;
        if (this.dragon.isBreathingFire()) {
            ++this.dragon.fireTicks;
            if (this.dragon.burnProgress < 40) {
                ++this.dragon.burnProgress;
            }
        } else {
            this.dragon.burnProgress = 0;
        }
        if (this.dragon.flightCycle == 2 && !this.dragon.isDiving() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            float dragonSoundVolume = IafConfig.dragonFlapNoiseDistance;
            float dragonSoundPitch = this.dragon.func_70647_i();
            this.dragon.func_184185_a(IafSoundRegistry.DRAGON_FLIGHT, dragonSoundVolume, dragonSoundPitch);
        }
        this.dragon.flightCycle = this.dragon.flightCycle < 58 ? (this.dragon.flightCycle += 2) : 0;
        boolean flying = this.dragon.isFlying();
        if (flying) {
            if (this.dragon.flyProgress < 20.0f) {
                this.dragon.flyProgress += 0.5f;
            }
        } else if (this.dragon.flyProgress > 0.0f) {
            this.dragon.flyProgress -= 2.0f;
        }
        boolean bl = sleeping = this.dragon.func_70608_bn() && !this.dragon.isHovering() && !flying;
        if (sleeping) {
            if (this.dragon.sleepProgress < 20.0f) {
                this.dragon.sleepProgress += 0.5f;
            }
        } else if (this.dragon.sleepProgress > 0.0f) {
            this.dragon.sleepProgress -= 0.5f;
        }
        boolean bl2 = sitting = this.dragon.func_233685_eM_() && !this.dragon.isModelDead() && !sleeping;
        if (sitting) {
            if (this.dragon.sitProgress < 20.0f) {
                this.dragon.sitProgress += 0.5f;
            }
        } else if (this.dragon.sitProgress > 0.0f) {
            this.dragon.sitProgress -= 0.5f;
        }
        boolean fireBreathing = this.dragon.isBreathingFire();
        this.dragon.prevFireBreathProgress = this.dragon.fireBreathProgress;
        if (fireBreathing) {
            if (this.dragon.fireBreathProgress < 10.0f) {
                this.dragon.fireBreathProgress += 0.5f;
            }
        } else if (this.dragon.fireBreathProgress > 0.0f) {
            this.dragon.fireBreathProgress -= 0.5f;
        }
        boolean bl3 = hovering = this.dragon.isHovering() || this.dragon.isFlying() && this.dragon.airAttack == IafDragonAttacks.Air.HOVER_BLAST && this.dragon.func_70638_az() != null && this.dragon.func_70032_d((Entity)this.dragon.func_70638_az()) < 17.0f;
        if (hovering) {
            if (this.dragon.hoverProgress < 20.0f) {
                this.dragon.hoverProgress += 0.5f;
            }
        } else if (this.dragon.hoverProgress > 0.0f) {
            this.dragon.hoverProgress -= 2.0f;
        }
        if (diving = this.dragon.isDiving()) {
            if (this.dragon.diveProgress < 10.0f) {
                this.dragon.diveProgress += 1.0f;
            }
        } else if (this.dragon.diveProgress > 0.0f) {
            this.dragon.diveProgress -= 2.0f;
        }
        boolean bl4 = tackling = this.dragon.isTackling() && this.dragon.isOverAir();
        if (tackling) {
            if (this.dragon.tackleProgress < 5.0f) {
                this.dragon.tackleProgress += 0.5f;
            }
        } else if (this.dragon.tackleProgress > 0.0f) {
            this.dragon.tackleProgress -= 1.5f;
        }
        if (modelDead = this.dragon.isModelDead()) {
            if (this.dragon.modelDeadProgress < 20.0f) {
                this.dragon.modelDeadProgress += 0.5f;
            }
        } else if (this.dragon.modelDeadProgress > 0.0f) {
            this.dragon.modelDeadProgress -= 0.5f;
        }
        boolean bl5 = riding = this.dragon.func_184218_aH() && this.dragon.func_184187_bx() != null && this.dragon.func_184187_bx() instanceof PlayerEntity;
        if (riding) {
            if (this.dragon.ridingProgress < 20.0f) {
                this.dragon.ridingProgress += 0.5f;
            }
        } else if (this.dragon.ridingProgress > 0.0f) {
            this.dragon.ridingProgress -= 0.5f;
        }
        if (this.dragon.hasHadHornUse) {
            this.dragon.hasHadHornUse = false;
        }
        if (this.dragon.groundAttack == IafDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            if (this.dragon.field_70170_p.field_72995_K) {
                this.dragon.spawnBabyParticles();
            }
            this.dragon.randomizeAttacks();
        }
    }

    public void updateDragonAttack() {
        LivingEntity target;
        double dist;
        PlayerEntity ridingPlayer = this.dragon.getRidingPlayer();
        if (this.dragon.isPlayingAttackAnimation() && this.dragon.func_70638_az() != null && this.dragon.func_70685_l((Entity)this.dragon.func_70638_az()) && (dist = (double)this.dragon.func_70032_d((Entity)(target = this.dragon.func_70638_az()))) < (double)this.dragon.getRenderSize() * 0.2574 * 2.0 + 2.0) {
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_BITE) {
                if (this.dragon.getAnimationTick() > 15 && this.dragon.getAnimationTick() < 25) {
                    this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                    this.dragon.usingGroundAttack = this.dragon.func_70681_au().nextBoolean();
                    this.dragon.randomizeAttacks();
                }
            } else if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_TAILWHACK) {
                if (this.dragon.getAnimationTick() > 20 && this.dragon.getAnimationTick() < 30) {
                    this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                    target.func_233627_a_((float)this.dragon.getDragonStage() * 0.6f, (double)MathHelper.func_76126_a((float)(this.dragon.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.dragon.field_70177_z * ((float)Math.PI / 180)))));
                    this.dragon.usingGroundAttack = this.dragon.func_70681_au().nextBoolean();
                    this.dragon.randomizeAttacks();
                }
            } else if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 15 || this.dragon.getAnimationTick() == 25 || this.dragon.getAnimationTick() == 35)) {
                this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.func_110148_a(Attributes.field_233823_f_).func_111126_e());
                target.func_233627_a_((float)this.dragon.getDragonStage() * 0.6f, (double)MathHelper.func_76126_a((float)(this.dragon.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.dragon.field_70177_z * ((float)Math.PI / 180)))));
                this.dragon.usingGroundAttack = this.dragon.func_70681_au().nextBoolean();
                this.dragon.randomizeAttacks();
            }
        }
    }

    public void debug() {
        String side = this.dragon.field_70170_p.field_72995_K ? "CLIENT" : "SERVER";
        String owner = this.dragon.func_70902_q() == null ? "null" : this.dragon.func_70902_q().func_200200_C_().getString();
        String attackTarget = this.dragon.func_70638_az() == null ? "null" : this.dragon.func_70638_az().func_200200_C_().getString();
        IceAndFire.LOGGER.warn("DRAGON DEBUG[" + side + "]:\nStage: " + this.dragon.getDragonStage() + "\nAge: " + this.dragon.getAgeInDays() + "\nVariant: " + this.dragon.getVariantName(this.dragon.getVariant()) + "\nOwner: " + owner + "\nAttack Target: " + attackTarget + "\nFlying: " + this.dragon.isFlying() + "\nHovering: " + this.dragon.isHovering() + "\nHovering Time: " + this.dragon.hoverTicks + "\nWidth: " + this.dragon.func_213311_cf() + "\nMoveHelper: " + this.dragon.func_70605_aq() + "\nGround Attack: " + (Object)((Object)this.dragon.groundAttack) + "\nAir Attack: " + (Object)((Object)this.dragon.airAttack) + "\nTackling: " + this.dragon.isTackling());
    }

    public void debugPathfinder(Path currentPath) {
        if (IceAndFire.DEBUG) {
            try {
                for (int i = 0; i < currentPath.func_75874_d(); ++i) {
                    PathPoint point = currentPath.func_75877_a(i);
                    IceAndFire.sendMSGToAll(new MessageSpawnParticleAt(point.field_75839_a, point.field_75837_b, point.field_75838_c, 2));
                }
                if (currentPath.func_242948_g() != null) {
                    Vector3d point = Vector3d.func_237489_a_((Vector3i)currentPath.func_242948_g());
                    IceAndFire.sendMSGToAll(new MessageSpawnParticleAt(point.field_72450_a, point.field_72448_b, point.field_72449_c, 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

