/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityStymphalianFeather
extends AbstractArrowEntity {
    public EntityStymphalianFeather(EntityType<? extends AbstractArrowEntity> t, World worldIn) {
        super(t, worldIn);
    }

    public EntityStymphalianFeather(EntityType<? extends AbstractArrowEntity> t, World worldIn, LivingEntity shooter) {
        super(t, shooter, worldIn);
        this.func_70239_b(IafConfig.stymphalianBirdFeatherAttackStength);
    }

    public EntityStymphalianFeather(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this((EntityType<? extends AbstractArrowEntity>)((EntityType)IafEntityRegistry.STYMPHALIAN_FEATHER.get()), world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (IafConfig.stymphalianBirdFeatherDropChance > 0 && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(IafConfig.stymphalianBirdFeatherDropChance) == 0) {
            this.func_70099_a(this.func_184550_j(), 0.1f);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 100) {
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult entityHit) {
        Entity shootingEntity = this.func_234616_v_();
        if (shootingEntity instanceof EntityStymphalianBird && entityHit.func_216348_a() != null && entityHit.func_216348_a() instanceof EntityStymphalianBird) {
            return;
        }
        super.func_213868_a(entityHit);
        if (entityHit.func_216348_a() != null && entityHit.func_216348_a() instanceof EntityStymphalianBird) {
            ItemStack itemstack1;
            LivingEntity LivingEntity2 = (LivingEntity)entityHit.func_216348_a();
            LivingEntity2.func_85034_r(LivingEntity2.func_85035_bI() - 1);
            ItemStack itemStack = itemstack1 = LivingEntity2.func_184587_cr() ? LivingEntity2.func_184607_cu() : ItemStack.field_190927_a;
            if (itemstack1.func_77973_b().isShield(itemstack1, LivingEntity2)) {
                this.damageShield(LivingEntity2, 1.0f);
            }
        }
    }

    protected void damageShield(LivingEntity entity, float damage) {
        if (damage >= 3.0f && entity.func_184607_cu().func_77973_b().isShield(entity.func_184607_cu(), entity)) {
            ItemStack copyBeforeUse = entity.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            Hand Hand2 = entity.func_184600_cs();
            copyBeforeUse.func_222118_a(i, entity, player1 -> player1.func_213334_d(Hand2));
            if (entity.func_184607_cu().func_190926_b()) {
                if (entity instanceof PlayerEntity) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)((PlayerEntity)entity), (ItemStack)copyBeforeUse, (Hand)Hand2);
                }
                if (Hand2 == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)IafItemRegistry.STYMPHALIAN_BIRD_FEATHER);
    }
}

