/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexQueenAIWander;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.entity.util.MyrmexTrades;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityMyrmexQueen
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final Animation ANIMATION_EGG = Animation.create((int)20);
    public static final Animation ANIMATION_DIGNEST = Animation.create((int)45);
    public static final ResourceLocation DESERT_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_queen_desert");
    public static final ResourceLocation JUNGLE_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_queen_jungle");
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_queen.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_queen.png");
    private static final DataParameter<Boolean> HASMADEHOME = EntityDataManager.func_187226_a(EntityMyrmexQueen.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int eggTicks = 0;

    public EntityMyrmexQueen(EntityType<EntityMyrmexQueen> t, World worldIn) {
        super(t, worldIn);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 20;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HASMADEHOME, (Object)true);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_QUEEN.get(1) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_QUEEN.get(1);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_QUEEN.get(2) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_QUEEN.get(2);
    }

    public void func_200203_b(ITextComponent name) {
        if (this.getHive() != null && !this.getHive().colonyName.equals(name.func_150261_e())) {
            this.getHive().colonyName = name.getString();
        }
        super.func_200203_b(name);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("EggTicks", this.eggTicks);
        tag.func_74757_a("MadeHome", this.hasMadeHome());
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.eggTicks = tag.func_74762_e("EggTicks");
        this.setMadeHome(tag.func_74767_n("MadeHome"));
    }

    public boolean hasMadeHome() {
        return (Boolean)this.field_70180_af.func_187225_a(HASMADEHOME);
    }

    public void setMadeHome(boolean madeHome) {
        this.field_70180_af.func_187227_b(HASMADEHOME, (Object)madeHome);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_DIGNEST) {
            this.spawnGroundEffects(3.0f);
        }
        if (this.getHive() != null) {
            this.getHive().tick(0, this.field_70170_p);
        }
        if (this.hasMadeHome() && this.getGrowthStage() >= 2 && !this.canSeeSky()) {
            ++this.eggTicks;
        } else if (this.canSeeSky()) {
            this.setAnimation(ANIMATION_DIGNEST);
            if (this.getAnimationTick() == 42) {
                int down = Math.max(15, this.func_233580_cy_().func_177956_o() - 20 + this.func_70681_au().nextInt(10));
                BlockPos genPos = new BlockPos(this.func_226277_ct_(), (double)down, this.func_226281_cx_());
                if (!MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, genPos.func_177958_n(), genPos.func_177956_o(), genPos.func_177952_p()))) {
                    WorldGenMyrmexHive hiveGen = new WorldGenMyrmexHive(true, this.isJungle(), (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
                    if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
                        hiveGen.placeSmallGen((ISeedReader)((ServerWorld)this.field_70170_p), this.func_70681_au(), genPos);
                    }
                    this.setMadeHome(true);
                    this.func_70012_b(genPos.func_177958_n(), down, genPos.func_177952_p(), 0.0f, 0.0f);
                    this.func_195064_c(new EffectInstance(Effects.field_76441_p, 30));
                    this.setHive(hiveGen.hive);
                    for (int i = 0; i < 3; ++i) {
                        EntityMyrmexWorker worker = new EntityMyrmexWorker((EntityType<EntityMyrmexWorker>)((EntityType)IafEntityRegistry.MYRMEX_WORKER.get()), this.field_70170_p);
                        worker.func_82149_j((Entity)this);
                        worker.setHive(this.getHive());
                        worker.setJungleVariant(this.isJungle());
                        if (this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_217376_c((Entity)worker);
                    }
                    return;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.eggTicks > IafConfig.myrmexPregnantTicks && this.getHive() == null || !this.field_70170_p.field_72995_K && this.getHive() != null && this.getHive().repopulate() && this.eggTicks > IafConfig.myrmexPregnantTicks) {
            float radius = -5.25f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos eggPos = new BlockPos(this.func_226277_ct_() + extraX, this.func_226278_cu_() + 0.75, this.func_226281_cx_() + extraZ);
            if (this.field_70170_p.func_175623_d(eggPos)) {
                this.setAnimation(ANIMATION_EGG);
                if (this.getAnimationTick() == 10) {
                    EntityMyrmexEgg egg = new EntityMyrmexEgg((EntityType)IafEntityRegistry.MYRMEX_EGG.get(), this.field_70170_p);
                    egg.setJungle(this.isJungle());
                    int caste = EntityMyrmexQueen.getRandomCaste(this.field_70170_p, this.func_70681_au(), this.getHive() == null || this.getHive().reproduces);
                    egg.setMyrmexCaste(caste);
                    egg.func_70012_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + 0.75, this.func_226281_cx_() + extraZ, 0.0f, 0.0f);
                    if (this.getHive() != null) {
                        egg.hiveUUID = this.getHive().hiveUUID;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)egg);
                    }
                    this.eggTicks = 0;
                }
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.getAnimationTick() == 0) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6 && this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
            LivingEntity attackTarget = this.func_70638_az();
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 2));
            this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 2));
            this.func_70638_az().field_70160_al = true;
            float f = MathHelper.func_76133_a((double)0.5);
            this.func_70638_az().field_70160_al = true;
            attackTarget.func_213317_d(attackTarget.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
            attackTarget.func_213317_d(attackTarget.func_213322_ci().func_72441_c(-0.5 / (double)f * 4.0, 1.0, -0.5 / (double)f * 4.0));
            if (this.func_70638_az().func_233570_aj_()) {
                attackTarget.func_213317_d(attackTarget.func_213322_ci().func_72441_c(0.0, 0.4, 0.0));
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.getAnimation() == ANIMATION_DIGNEST;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MyrmexQueenAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, true, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return entity != null && !EntityMyrmexBase.haveSameHive(EntityMyrmexQueen.this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof IMob);
            }
        }));
    }

    public void fall(float distance, float damageMultiplier) {
    }

    @Override
    public boolean isInHive() {
        if (this.getHive() != null) {
            for (BlockPos pos : this.getHive().getAllRooms()) {
                if (!this.isCloseEnoughToTarget(MyrmexHive.getGroundedPos((IWorld)this.func_190670_t_(), pos), 300.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, IafConfig.myrmexBaseAttackStrength * 3.5).func_233815_a_(Attributes.field_233819_b_, 128.0).func_233815_a_(Attributes.field_233826_i_, 15.0);
    }

    @Override
    public AttributeModifierMap.MutableAttribute getAttributes() {
        return EntityMyrmexQueen.bakeAttributes();
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.75f;
    }

    @Override
    public int getCasteImportance() {
        return 3;
    }

    @Override
    public boolean shouldLeaveHive() {
        return false;
    }

    @Override
    public boolean shouldEnterHive() {
        return true;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
            if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(Hand.MAIN_HAND) != ItemStack.field_190927_a) {
                this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity entity : this.func_184188_bt()) {
                    entity.func_184210_p();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.hasMadeHome();
    }

    public void spawnGroundEffects(float size) {
        int i = 0;
        while ((float)i < size * 3.0f) {
            for (int i1 = 0; i1 < 10; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = size * this.field_70146_Z.nextFloat();
                float angle = (float)Math.PI / 180 * this.field_70761_aq * 3.14f * this.field_70146_Z.nextFloat();
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                BlockState BlockState2 = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.func_226277_ct_() + extraX)), MathHelper.func_76128_c((double)(this.func_226278_cu_() + extraY)) - 1, MathHelper.func_76128_c((double)(this.func_226281_cx_() + extraZ))));
                if (BlockState2.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195590_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, BlockState2), true, this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING, ANIMATION_EGG, ANIMATION_DIGNEST};
    }

    public int func_213708_dV() {
        return 0;
    }

    public boolean func_213705_dZ() {
        return false;
    }
}

