/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySlowPart;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIAttack;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIFindSandTarget;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIGetInSand;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIJump;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DeathwormAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.EntityGroundAIRide;
import com.github.alexthe666.iceandfire.entity.ai.IAFLookHelper;
import com.github.alexthe666.iceandfire.entity.util.BlockLaunchExplosion;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.entity.util.IGroundMount;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.message.MessageDeathWormHitbox;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDeathWormLand;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDeathWormSand;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityDeathWorm
extends TameableEntity
implements ISyncMount,
ICustomCollisions,
IBlacklistedFromStatues,
IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IGroundMount,
IHasCustomizableAttributes,
ICustomMoveController {
    public static final ResourceLocation TAN_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_tan");
    public static final ResourceLocation WHITE_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_white");
    public static final ResourceLocation RED_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_red");
    public static final ResourceLocation TAN_GIANT_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_tan_giant");
    public static final ResourceLocation WHITE_GIANT_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_white_giant");
    public static final ResourceLocation RED_GIANT_LOOT = new ResourceLocation("iceandfire", "entities/deathworm_red_giant");
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> JUMP_TICKS = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> WORM_AGE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> HOME = EntityDataManager.func_187226_a(EntityDeathWorm.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static Animation ANIMATION_BITE = Animation.create((int)10);
    public ChainBuffer tail_buffer;
    public float jumpProgress;
    public float prevJumpProgress;
    private int animationTick;
    private boolean willExplode = false;
    private int ticksTillExplosion = 60;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[6];
    private boolean isSandNavigator;
    private final float prevScale = 0.0f;
    private final LookController lookHelper;
    private int growthCounter = 0;
    private PlayerEntity thrower;
    public DeathwormAITargetItems targetItemsGoal;

    public EntityDeathWorm(EntityType<EntityDeathWorm> type, World worldIn) {
        super(type, worldIn);
        IHasCustomizableAttributes.applyAttributesForEntity(type, this);
        this.lookHelper = new IAFLookHelper((MobEntity)this);
        this.field_70158_ak = true;
        this.field_70138_W = 1.0f;
        if (worldIn.field_72995_K) {
            this.tail_buffer = new ChainBuffer();
        }
        this.switchNavigator(false);
        this.field_70714_bg.func_75776_a(0, new EntityGroundAIRide<EntityDeathWorm>(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new DeathWormAIAttack(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new DeathWormAIJump(this, 12));
        this.field_70714_bg.func_75776_a(4, (Goal)new DeathWormAIFindSandTarget(this, 10));
        this.field_70714_bg.func_75776_a(5, (Goal)new DeathWormAIGetInSand(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new DeathWormAIWander(this, 1.0));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.targetItemsGoal = new DeathwormAITargetItems(this, false, false);
        this.field_70715_bh.func_75776_a(4, this.targetItemsGoal);
        this.field_70715_bh.func_75776_a(5, new DeathWormAITarget<LivingEntity>(this, LivingEntity.class, false, new Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity input) {
                if (EntityDeathWorm.this.func_70909_n()) {
                    return input instanceof MonsterEntity;
                }
                return (IafConfig.deathWormAttackMonsters ? input instanceof LivingEntity && DragonUtils.isAlive(input) && !input.func_70090_H() : input instanceof AnimalEntity || input instanceof PlayerEntity) && DragonUtils.isAlive(input) && (!(input instanceof EntityDragonBase) || !((EntityDragonBase)input).isModelDead()) && !EntityDeathWorm.this.func_152114_e(input) && !input.func_70090_H();
            }
        }));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.deathWormMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233823_f_, IafConfig.deathWormAttackStrength).func_233815_a_(Attributes.field_233819_b_, (double)IafConfig.deathWormTargetSearchLength).func_233815_a_(Attributes.field_233826_i_, 3.0);
    }

    @Override
    public AttributeModifierMap.MutableAttribute getAttributes() {
        return EntityDeathWorm.bakeAttributes();
    }

    public LookController func_70671_ap() {
        return this.lookHelper;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean getCanSpawnHere() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        return BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c()) && this.func_70681_au().nextInt(1 + IafConfig.deathWormSpawnCheckChance) == 0 && this.field_70170_p.func_201696_r(blockpos) > 8;
    }

    public void onUpdateParts() {
        this.addSegmentsToWorld();
        if (this.isSandBelow()) {
            int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 1.0));
            int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState BlockState2 = this.field_70170_p.func_180495_p(blockpos);
            if (this.field_70170_p.field_72995_K) {
                // empty if block
            }
        }
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.func_213355_cm() > 3.0f ? 20 : 10;
    }

    public void initSegments(float scale) {
        this.segments = new EntityMutlipartPart[7];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new EntitySlowPart((Entity)this, (-0.8f - (float)i * 0.8f) * scale, 0.0f, 0.0f, 0.7f * scale, 0.7f * scale, 1.0f);
            this.segments[i].func_82149_j((Entity)this);
            this.segments[i].setParent((Entity)this);
        }
    }

    private void addSegmentsToWorld() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            if (!entity.shouldContinuePersisting()) {
                this.field_70170_p.func_217376_c((Entity)entity);
            }
            entity.setParent((Entity)this);
        }
    }

    private void clearSegments() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_174812_G();
            entity.func_70106_y();
        }
    }

    public void setExplosive(boolean explosive, PlayerEntity thrower) {
        this.willExplode = true;
        this.ticksTillExplosion = 60;
        this.thrower = thrower;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.func_184185_a(this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_ATTACK : IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
        }
        if (this.func_70681_au().nextInt(3) == 0 && this.func_213355_cm() > 1.0f && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && !MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_()))) {
            BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.field_70170_p, (MobEntity)this, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), this.func_213355_cm());
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        this.clearSegments();
        super.func_70645_a(cause);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getVariant()) {
            case 0: {
                return this.func_213355_cm() > 3.0f ? TAN_GIANT_LOOT : TAN_LOOT;
            }
            case 1: {
                return this.func_213355_cm() > 3.0f ? RED_GIANT_LOOT : RED_LOOT;
            }
            case 2: {
                return this.func_213355_cm() > 3.0f ? WHITE_GIANT_LOOT : WHITE_LOOT;
            }
        }
        return null;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WORM_AGE, (Object)10);
        this.field_70180_af.func_187214_a(HOME, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(JUMP_TICKS, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("GrowthCounter", this.growthCounter);
        compound.func_74776_a("Scale", this.getDeathwormScale());
        compound.func_74768_a("WormAge", this.getWormAge());
        compound.func_74772_a("WormHome", this.getWormHome().func_218275_a());
        compound.func_74757_a("WillExplode", this.willExplode);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.growthCounter = compound.func_74762_e("GrowthCounter");
        this.setDeathWormScale(compound.func_74760_g("Scale"));
        this.setWormAge(compound.func_74762_e("WormAge"));
        this.setWormHome(BlockPos.func_218283_e((long)compound.func_74763_f("WormHome")));
        this.willExplode = compound.func_74767_n("WillExplode");
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getWormJumping() {
        return (Integer)this.field_70180_af.func_187225_a(JUMP_TICKS);
    }

    public void setWormJumping(int jump) {
        this.field_70180_af.func_187227_b(JUMP_TICKS, (Object)jump);
    }

    public BlockPos getWormHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME);
    }

    public void setWormHome(BlockPos home) {
        if (home instanceof BlockPos) {
            this.field_70180_af.func_187227_b(HOME, (Object)home);
        }
    }

    public int getWormAge() {
        return Math.max(1, (Integer)this.field_70180_af.func_187225_a(WORM_AGE));
    }

    public void setWormAge(int age) {
        this.field_70180_af.func_187227_b(WORM_AGE, (Object)age);
    }

    public float func_213355_cm() {
        return Math.min(this.getDeathwormScale() * ((float)this.getWormAge() / 5.0f), 7.0f);
    }

    public float getDeathwormScale() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue()).floatValue();
    }

    public void setDeathWormScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
        this.clearSegments();
        if (!this.field_70170_p.field_72995_K) {
            this.initSegments(scale * ((float)this.getWormAge() / 5.0f));
            IceAndFire.sendMSGToAll(new MessageDeathWormHitbox(this.func_145782_y(), scale * ((float)this.getWormAge() / 5.0f)));
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(3));
        float size = 0.25f + (float)(Math.random() * (double)0.35f);
        this.setDeathWormScale(this.func_70681_au().nextInt(20) == 0 ? size * 4.0f : size);
        return spawnDataIn;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
            float radius = -0.5f * this.func_213355_cm();
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)this.func_70047_e() - (double)0.55f, this.func_226281_cx_() + extraZ);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.getWormAge() > 4 && player.func_184187_bx() == null && player.func_184614_ca().func_77973_b() == Items.field_151112_aM && player.func_184592_cb().func_77973_b() == Items.field_151112_aM && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private void switchNavigator(boolean inSand) {
        if (inSand) {
            this.field_70765_h = new SandMoveHelper();
            this.field_70699_by = new PathNavigateDeathWormSand(this, this.field_70170_p);
            this.isSandNavigator = true;
        } else {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new PathNavigateDeathWormLand(this, this.field_70170_p);
            this.isSandNavigator = false;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_82729_p) {
            return false;
        }
        if (this.func_184207_aI() && source.func_76346_g() != null && this.func_184179_bs() != null && source.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
    }

    public Vector3d func_213306_e(Vector3d vec) {
        return ICustomCollisions.getAllowedMovementForEntity((Entity)this, (Vector3d)vec);
    }

    public boolean func_70094_T() {
        if (this.isInSand()) {
            return false;
        }
        return super.func_70094_T();
    }

    protected void func_213282_i(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vector3d vector3d = new Vector3d(x - (double)blockpos.func_177958_n(), y - (double)blockpos.func_177956_o(), z - (double)blockpos.func_177952_p());
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, direction1);
            if (this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_235785_r_((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable) && !BlockTags.field_203436_u.func_230235_a_((Object)this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_177230_c())) continue;
            double d1 = vector3d.func_216370_a(direction1.func_176740_k());
            double d = d2 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        float f1 = direction.func_176743_c().func_179524_a();
        Vector3d vector3d1 = this.func_213322_ci().func_186678_a(0.75);
        if (direction.func_176740_k() == Direction.Axis.X) {
            this.func_213293_j(f1 * f, vector3d1.field_72448_b, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Y) {
            this.func_213293_j(vector3d1.field_72450_a, f1 * f, vector3d1.field_72449_c);
        } else if (direction.func_176740_k() == Direction.Axis.Z) {
            this.func_213293_j(vector3d1.field_72450_a, vector3d1.field_72448_b, f1 * f);
        }
    }

    private void updateAttributes() {
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(Math.min(0.2, 0.15 * (double)this.func_213355_cm()));
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(Math.max(1.0, IafConfig.deathWormAttackStrength * (double)this.func_213355_cm()));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(Math.max(6.0, IafConfig.deathWormMaxHealth * (double)this.func_213355_cm()));
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a((double)IafConfig.deathWormTargetSearchLength);
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111125_b());
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        if (this.func_70909_n()) {
            this.func_70691_i(14.0f);
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevJumpProgress = this.jumpProgress;
        if (this.getWormJumping() > 0 && this.jumpProgress < 5.0f) {
            this.jumpProgress += 1.0f;
        }
        if (this.getWormJumping() == 0 && this.jumpProgress > 0.0f) {
            this.jumpProgress -= 1.0f;
        }
        if (this.isInSand() && this.field_70123_F) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.05, 0.0));
        }
        if (this.getWormJumping() > 0) {
            float f2;
            this.field_70125_A = f2 = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
            if (this.isInSand() || this.func_233570_aj_()) {
                this.setWormJumping(this.getWormJumping() - 1);
            }
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (!(this.func_70638_az() == null || this.func_70638_az().func_70089_S() && DragonUtils.isAlive(this.func_70638_az()))) {
            this.func_70624_b(null);
        }
        if (this.willExplode) {
            if (this.ticksTillExplosion == 0) {
                boolean b;
                boolean bl = b = !MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()));
                if (b) {
                    this.field_70170_p.func_217398_a((Entity)this.thrower, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.5f * this.func_213355_cm(), false, Explosion.Mode.DESTROY);
                }
                this.thrower = null;
            } else {
                --this.ticksTillExplosion;
            }
        }
        if (this.field_70173_aa == 1) {
            this.initSegments(this.func_213355_cm());
        }
        if (this.isInSandStrict()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.08, 0.0));
        }
        if (this.growthCounter > 1000 && this.getWormAge() < 5) {
            this.growthCounter = 0;
            this.setWormAge(Math.min(5, this.getWormAge() + 1));
            this.clearSegments();
            this.func_70691_i(15.0f);
            this.setDeathWormScale(this.getDeathwormScale());
            if (this.field_70170_p.field_72995_K) {
                int i = 0;
                while ((float)i < 10.0f * this.func_213355_cm()) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), (double)((float)this.getSurface((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226278_cu_()), (int)Math.floor(this.func_226281_cx_())) + 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
                    ++i;
                }
            }
        }
        if (this.getWormAge() < 5) {
            ++this.growthCounter;
        }
        if (this.func_184179_bs() != null && this.func_70638_az() != null) {
            this.func_70661_as().func_75499_g();
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && (double)this.func_70032_d((Entity)this.func_70638_az()) < Math.min(4.0, 4.0 * (double)this.func_213355_cm()) && this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 5) {
            float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.4f, 0.0));
        }
    }

    public int getWormBrightness(boolean sky) {
        BlockPos eyePos = new BlockPos(this.func_174824_e(1.0f));
        while (eyePos.func_177956_o() < 256 && !this.field_70170_p.func_175623_d(eyePos)) {
            eyePos = eyePos.func_177984_a();
        }
        int light = this.field_70170_p.func_226658_a_(sky ? LightType.SKY : LightType.BLOCK, eyePos.func_177984_a());
        return light;
    }

    public int getSurface(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        while (!this.field_70170_p.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        return pos.func_177956_o();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_IDLE : IafSoundRegistry.DEATHWORM_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_HURT : IafSoundRegistry.DEATHWORM_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_DIE : IafSoundRegistry.DEATHWORM_DIE;
    }

    public void func_70071_h_() {
        boolean inSand;
        super.func_70071_h_();
        this.func_213323_x_();
        this.onUpdateParts();
        if (this.attack() && this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity) {
            LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((PlayerEntity)this.func_184179_bs()), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
                this.func_184185_a(this.func_213355_cm() > 3.0f ? IafSoundRegistry.DEATHWORM_GIANT_ATTACK : IafSoundRegistry.DEATHWORM_ATTACK, 1.0f, 1.0f);
                if (this.func_70681_au().nextInt(3) == 0 && this.func_213355_cm() > 1.0f) {
                    float radius = 1.5f * this.func_213355_cm();
                    float angle = (float)Math.PI / 180 * this.field_70761_aq;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.field_70170_p, (MobEntity)this, this.func_226277_ct_() + extraX, this.func_226278_cu_() - (double)this.func_70047_e(), this.func_226281_cx_() + extraZ, this.func_213355_cm() * 0.75f);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
            }
            if (target != null) {
                target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            }
        }
        if (this.isInSand()) {
            BlockPos pos = new BlockPos(this.func_226277_ct_(), (double)this.getSurface((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226278_cu_()), (int)Math.floor(this.func_226281_cx_())), this.func_226281_cx_()).func_177977_b();
            BlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_200015_d((IBlockReader)this.field_70170_p, pos) && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), (double)((float)this.getSurface((int)Math.floor(this.func_226277_ct_()), (int)Math.floor(this.func_226278_cu_()), (int)Math.floor(this.func_226281_cx_())) + 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
            }
            if (this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_187747_eB, 1.0f, 0.5f);
            }
        }
        if (this.up() && this.field_70122_E) {
            this.func_70664_aZ();
        }
        boolean bl = inSand = this.isInSand() || this.func_184179_bs() == null;
        if (inSand && !this.isSandNavigator) {
            this.switchNavigator(true);
        }
        if (!inSand && this.isSandNavigator) {
            this.switchNavigator(false);
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (LivingEntity)this);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean dismountIAF() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(1, dismount);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
    }

    public boolean isSandBelow() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() + 1.0)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
        BlockState BlockState2 = this.field_70170_p.func_180495_p(blockpos);
        return BlockState2.func_185904_a() == Material.field_151595_p;
    }

    public boolean isInSand() {
        return this.func_184179_bs() == null && this.isInSandStrict();
    }

    public boolean isInSandStrict() {
        return this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_235714_a_((ITag)BlockTags.field_203436_u);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public Entity[] getWormParts() {
        return this.segments;
    }

    public int func_184649_cE() {
        return 10;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_213352_e(Vector3d vec) {
        super.func_213352_e(vec);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean canPassThrough(BlockPos pos, BlockState state, VoxelShape shape) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151595_p;
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRidingPlayer(PlayerEntity player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public PlayerEntity getRidingPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    @Override
    public double getRideSpeedModifier() {
        return this.isInSand() ? 1.5 : 1.0;
    }

    public double processRiderY(double y) {
        return this.isInSand() ? y + (double)0.2f : y;
    }

    public class SandMoveHelper
    extends MovementController {
        private final EntityDeathWorm worm;

        public SandMoveHelper() {
            super((MobEntity)EntityDeathWorm.this);
            this.worm = EntityDeathWorm.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double d1 = this.field_75647_c - this.worm.func_226278_cu_();
                double d2 = this.field_75644_d - this.worm.func_226281_cx_();
                Vector3d Vector3d2 = new Vector3d(this.field_75646_b - this.worm.func_226277_ct_(), this.field_75647_c - this.worm.func_226278_cu_(), this.field_75644_d - this.worm.func_226281_cx_());
                double d0 = Vector3d2.func_72433_c();
                if (d0 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    this.field_75645_e = 1.0;
                    this.worm.func_213317_d(this.worm.func_213322_ci().func_178787_e(Vector3d2.func_186678_a(this.field_75645_e * 0.05 / d0)));
                    Vector3d Vector3d1 = this.worm.func_213322_ci();
                    this.worm.field_70177_z = -((float)MathHelper.func_181159_b((double)Vector3d1.field_72450_a, (double)Vector3d1.field_72449_c)) * 57.295776f;
                }
            }
        }
    }
}

