/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityCyclopsEye;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.ai.CyclopsAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.CyclopsAITargetSheepPlayers;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateCyclops;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityCyclops
extends MonsterEntity
implements IAnimatedEntity,
IBlacklistedFromStatues,
IVillagerFear,
IHumanoid,
IHasCustomizableAttributes {
    private static final DataParameter<Boolean> BLINDED = EntityDataManager.func_187226_a(EntityCyclops.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityCyclops.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_STOMP;
    public static Animation ANIMATION_EATPLAYER;
    public static Animation ANIMATION_KICK;
    public static Animation ANIMATION_ROAR;
    public EntityCyclopsEye eyeEntity;
    private int animationTick;
    private Animation currentAnimation;

    public EntityCyclops(EntityType<EntityCyclops> type, World worldIn) {
        super(type, worldIn);
        IHasCustomizableAttributes.applyAttributesForEntity(type, this);
        this.field_70138_W = 2.5f;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, 0.0f);
        ANIMATION_STOMP = Animation.create((int)27);
        ANIMATION_EATPLAYER = Animation.create((int)40);
        ANIMATION_KICK = Animation.create((int)20);
        ANIMATION_ROAR = Animation.create((int)30);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.cyclopsMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233823_f_, IafConfig.cyclopsAttackStrength).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 20.0);
    }

    @Override
    public AttributeModifierMap.MutableAttribute getAttributes() {
        return EntityCyclops.bakeAttributes();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new PathNavigateCyclops(this, this.field_70170_p);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 40;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FleeSunGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new CyclopsAIAttackMelee(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, true, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                PlayerEntity playerEntity;
                if (EntityGorgon.isStoneMob(entity)) {
                    return false;
                }
                if (!DragonUtils.isAlive(entity)) {
                    return false;
                }
                if (entity instanceof WaterMobEntity) {
                    return false;
                }
                if (entity instanceof PlayerEntity && ((playerEntity = (PlayerEntity)entity).func_184812_l_() || playerEntity.func_175149_v())) {
                    return false;
                }
                if (entity instanceof EntityCyclops) {
                    return false;
                }
                if (entity instanceof AnimalEntity && !(entity instanceof WolfEntity) && !(entity instanceof PolarBearEntity) && !(entity instanceof EntityDragonBase)) {
                    return false;
                }
                return !ServerEvents.isSheep((Entity)entity);
            }
        }));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, (Predicate)new com.google.common.base.Predicate<PlayerEntity>(){

            public boolean apply(@Nullable PlayerEntity entity) {
                return entity != null && !entity.func_184812_l_() && !entity.func_175149_v();
            }
        }));
        this.field_70715_bh.func_75776_a(3, new CyclopsAITargetSheepPlayers<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_82167_n(Entity entityIn) {
        if (!ServerEvents.isSheep(entityIn)) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        int attackDescision = this.func_70681_au().nextInt(3);
        if (attackDescision == 0) {
            this.setAnimation(ANIMATION_STOMP);
            return true;
        }
        if (attackDescision == 1) {
            if (!entityIn.func_184196_w((Entity)this) && entityIn.func_213311_cf() < 1.95f && !(entityIn instanceof EntityDragonBase) && !EntityTypeTags.func_219762_a().func_199910_a(IafTagRegistry.CYCLOPS_UNLIFTABLES).func_230235_a_((Object)entityIn.func_200600_R())) {
                this.setAnimation(ANIMATION_EATPLAYER);
                entityIn.func_184210_p();
                entityIn.func_184205_a((Entity)this, true);
            } else {
                this.setAnimation(ANIMATION_STOMP);
            }
            return true;
        }
        this.setAnimation(ANIMATION_KICK);
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BLINDED, (Object)false);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Blind", this.isBlinded());
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBlinded(compound.func_74767_n("Blind"));
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean isBlinded() {
        return (Boolean)this.field_70180_af.func_187225_a(BLINDED);
    }

    public void setBlinded(boolean blind) {
        this.field_70180_af.func_187227_b(BLINDED, (Object)blind);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            passenger.func_213293_j(0.0, passenger.func_213322_ci().field_72448_b, 0.0);
            this.setAnimation(ANIMATION_EATPLAYER);
            double raiseUp = this.getAnimationTick() < 10 ? 0.0 : Math.min((double)(this.getAnimationTick() * 3 - 30) * 0.2, (double)5.2f);
            float pullIn = this.getAnimationTick() < 15 ? 0.0f : Math.min((float)(this.getAnimationTick() - 15) * 0.15f, 0.75f);
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z *= 0.0f;
            float radius = -2.75f + pullIn;
            float angle = (float)Math.PI / 180 * this.field_70761_aq + 3.15f;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = raiseUp;
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ);
            if (this.getAnimationTick() == 32) {
                passenger.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)IafConfig.cyclopsBiteStrength);
                passenger.func_184210_p();
            }
        }
    }

    public void func_213352_e(Vector3d vec) {
        if (this.getAnimation() == ANIMATION_EATPLAYER) {
            super.func_213352_e(vec.func_216372_d(0.0, 0.0, 0.0));
            return;
        }
        super.func_213352_e(vec);
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.eyeEntity == null) {
            this.eyeEntity = new EntityCyclopsEye((LivingEntity)this, 0.2f, 0.0f, 7.4f, 1.2f, 0.6f, 1.0f);
            this.eyeEntity.func_82149_j((Entity)this);
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_70638_az() instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.isBlinded() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 6.0) {
            this.func_70624_b(null);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.func_184185_a(IafSoundRegistry.CYCLOPS_BLINDED, 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_EATPLAYER && this.getAnimationTick() == 25) {
            this.func_184185_a(IafSoundRegistry.CYCLOPS_BITE, 1.0f, 1.0f);
        }
        if (this.getAnimation() == ANIMATION_STOMP && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 12.0 && this.getAnimationTick() == 14) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
        if (this.getAnimation() == ANIMATION_KICK && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 14.0 && this.getAnimationTick() == 12) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
            this.func_70638_az().func_233627_a_(2.0f, this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_());
        }
        if (this.getAnimation() != ANIMATION_EATPLAYER && this.func_70638_az() != null && !this.func_184188_bt().isEmpty() && this.func_184188_bt().contains(this.func_70638_az())) {
            this.setAnimation(ANIMATION_EATPLAYER);
        }
        if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() != null && this.func_70681_au().nextInt(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() == 14) {
            for (int i1 = 0; i1 < 20; ++i1) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                float radius = -1.5f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq + (float)i1 * 1.0f;
                double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * MathHelper.func_76134_b((float)angle);
                BlockState BlockState2 = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)(this.func_226277_ct_() + extraX)), MathHelper.func_76128_c((double)(this.func_226278_cu_() + extraY)) - 1, MathHelper.func_76128_c((double)(this.func_226281_cx_() + extraZ))));
                if (BlockState2.func_185904_a() == Material.field_151579_a || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, BlockState2), this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ, motionX, motionY, motionZ);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.eyeEntity == null) {
            this.eyeEntity = new EntityCyclopsEye((LivingEntity)this, 0.2f, 0.0f, 7.4f, 1.2f, 0.5f, 1.0f);
            this.eyeEntity.func_82149_j((Entity)this);
            this.eyeEntity.setParent((Entity)this);
        }
        if (!this.eyeEntity.shouldContinuePersisting()) {
            this.field_70170_p.func_217376_c((Entity)this.eyeEntity);
        }
        this.eyeEntity.setParent((Entity)this);
        this.breakBlock();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.func_70681_au().nextInt(4));
        return spawnDataIn;
    }

    public void breakBlock() {
        if (IafConfig.cyclopsGriefing) {
            for (int a = (int)Math.round(this.func_174813_aQ().field_72340_a) - 1; a <= (int)Math.round(this.func_174813_aQ().field_72336_d) + 1; ++a) {
                for (int b = (int)Math.round(this.func_174813_aQ().field_72338_b) + 1; b <= (int)Math.round(this.func_174813_aQ().field_72337_e) + 2 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.func_174813_aQ().field_72339_c) - 1; c <= (int)Math.round(this.func_174813_aQ().field_72334_f) + 1; ++c) {
                        BlockPos pos = new BlockPos(a, b, c);
                        BlockState state = this.field_70170_p.func_180495_p(pos);
                        Block block = state.func_177230_c();
                        if (state.func_196958_f() || state.func_196954_c((IBlockReader)this.field_70170_p, pos).func_197766_b() || block instanceof BushBlock || block == Blocks.field_150357_h || !(state.func_177230_c() instanceof LeavesBlock) && !BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c())) continue;
                        this.func_213322_ci().func_186678_a(0.6);
                        if (MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, a, b, c)) || block == Blocks.field_150350_a || this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_175655_b(pos, true);
                    }
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public void func_70106_y() {
        if (this.eyeEntity != null) {
            this.eyeEntity.func_70106_y();
        }
        super.func_70106_y();
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STOMP, ANIMATION_EATPLAYER, ANIMATION_KICK, ANIMATION_ROAR};
    }

    public boolean isBlinking() {
        return this.field_70173_aa % 50 > 40 && !this.isBlinded();
    }

    public void onHitEye(DamageSource source, float damage) {
        if (!this.isBlinded()) {
            this.setBlinded(true);
            this.func_110148_a(Attributes.field_233819_b_).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.35);
            this.setAnimation(ANIMATION_ROAR);
            this.func_70097_a(source, damage * 3.0f);
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.CYCLOPS_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return IafSoundRegistry.CYCLOPS_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.CYCLOPS_DIE;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return !this.isBlinded();
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

