/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIAggroLook;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIStareAttack;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAITarget;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.CockatriceAIWander;
import com.github.alexthe666.iceandfire.entity.ai.EntityAIAttackMeleeNoCooldown;
import com.github.alexthe666.iceandfire.entity.ai.IAFLookHelper;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.event.ServerEvents;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityCockatrice
extends TameableEntity
implements IAnimatedEntity,
IBlacklistedFromStatues,
IVillagerFear,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_JUMPAT = Animation.create((int)30);
    public static final Animation ANIMATION_WATTLESHAKE = Animation.create((int)20);
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_EAT = Animation.create((int)20);
    public static final float VIEW_RADIUS = 0.6f;
    private static final DataParameter<Boolean> HEN = EntityDataManager.func_187226_a(EntityCockatrice.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STARING = EntityDataManager.func_187226_a(EntityCockatrice.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityCockatrice.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TAMING_PLAYER = EntityDataManager.func_187226_a(EntityCockatrice.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TAMING_LEVEL = EntityDataManager.func_187226_a(EntityCockatrice.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityCockatrice.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final CockatriceAIStareAttack aiStare;
    private final MeleeAttackGoal aiMelee;
    public float sitProgress;
    public float stareProgress;
    public int ticksStaring = 0;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isSitting;
    private boolean isStaring;
    private boolean isMeleeMode = false;
    private LivingEntity targetedEntity;
    private int clientSideAttackTime;

    public EntityCockatrice(EntityType<EntityCockatrice> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new IAFLookHelper((MobEntity)this);
        this.aiStare = new CockatriceAIStareAttack(this, 1.0, 0, 15.0f);
        this.aiMelee = new EntityAIAttackMeleeNoCooldown((CreatureEntity)this, 1.5, false);
        IHasCustomizableAttributes.applyAttributesForEntity(type, this);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, IafConfig.cockatriceMaxHealth).func_233815_a_(Attributes.field_233821_d_, 0.4).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 10;
    }

    public boolean getCanSpawnHere() {
        return this.func_70681_au().nextInt(IafConfig.cockatriceSpawnCheckChance + 1) == 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new CockatriceAIFollowOwner(this, 1.0, 7.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, LivingEntity.class, 14.0f, 1.0, 1.0, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                if (entity instanceof PlayerEntity) {
                    return !((PlayerEntity)entity).func_184812_l_() && !entity.func_175149_v();
                }
                return ServerEvents.doesScareCockatrice((Entity)entity) && !ServerEvents.isChicken((Entity)entity);
            }
        }));
        this.field_70714_bg.func_75776_a(4, (Goal)new CockatriceAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new CockatriceAIAggroLook(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, new CockatriceAITargetItems(this, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, new CockatriceAITarget<LivingEntity>(this, LivingEntity.class, true, (Predicate<LivingEntity>)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (entity instanceof PlayerEntity) {
                    return !((PlayerEntity)entity).func_184812_l_() && !entity.func_175149_v();
                }
                return entity instanceof IMob && EntityCockatrice.this.func_70909_n() && !(entity instanceof CreeperEntity) && !(entity instanceof ZombifiedPiglinEntity) && !(entity instanceof EndermanEntity) || ServerEvents.isCockatriceTarget(entity) && !ServerEvents.isChicken(entity);
            }
        }));
    }

    public boolean func_213394_dL() {
        return this.hasHomePosition && this.getCommand() == 3 && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.field_70170_p)) || super.func_213394_dL();
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (worldIn instanceof IServerWorld && !IafWorldRegistry.isDimensionListedForMobs((IServerWorld)this.field_70170_p)) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    public BlockPos func_213384_dI() {
        return this.hasHomePosition && this.getCommand() == 3 && this.homePos != null ? this.homePos.getPosition() : super.func_213384_dI();
    }

    public float func_213391_dJ() {
        return 30.0f;
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (ServerEvents.isChicken(entityIn)) {
            return true;
        }
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() != null && ServerEvents.doesScareCockatrice(source.func_76346_g())) {
            damage *= 5.0f;
        }
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    private boolean canUseStareOn(Entity entity) {
        return (!(entity instanceof IBlacklistedFromStatues) || ((IBlacklistedFromStatues)entity).canBeTurnedToStone()) && !ServerEvents.isCockatriceTarget(entity);
    }

    private void switchAI(boolean melee) {
        if (melee) {
            this.field_70714_bg.func_85156_a((Goal)this.aiStare);
            if (this.aiMelee != null) {
                this.field_70714_bg.func_75776_a(2, (Goal)this.aiMelee);
            }
            this.isMeleeMode = true;
        } else {
            this.field_70714_bg.func_85156_a((Goal)this.aiMelee);
            if (this.aiStare != null) {
                this.field_70714_bg.func_75776_a(2, (Goal)this.aiStare);
            }
            this.isMeleeMode = false;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.isStaring()) {
            return false;
        }
        if (this.func_70681_au().nextBoolean()) {
            if (this.getAnimation() != ANIMATION_JUMPAT && this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_JUMPAT);
            }
            return false;
        }
        if (this.getAnimation() != ANIMATION_BITE && this.getAnimation() != ANIMATION_JUMPAT) {
            this.setAnimation(ANIMATION_BITE);
        }
        return false;
    }

    @Override
    public AttributeModifierMap.MutableAttribute getAttributes() {
        return EntityCockatrice.bakeAttributes();
    }

    public boolean canMove() {
        return !this.func_233685_eM_() && (this.getAnimation() != ANIMATION_JUMPAT || this.getAnimationTick() >= 7);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEN, (Object)false);
        this.field_70180_af.func_187214_a(STARING, (Object)false);
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(TAMING_PLAYER, (Object)0);
        this.field_70180_af.func_187214_a(TAMING_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    public boolean hasTamingPlayer() {
        return (Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER) != 0;
    }

    @Nullable
    public Entity getTamingPlayer() {
        if (!this.hasTamingPlayer()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER)).intValue());
    }

    public void setTamingPlayer(int entityId) {
        this.field_70180_af.func_187227_b(TAMING_PLAYER, (Object)entityId);
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        boolean blindness;
        boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(Effects.field_76440_q) || EntityGorgon.isBlindfolded(this.func_70638_az());
        if (blindness) {
            return null;
        }
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    public void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals(key)) {
            this.clientSideAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a("Hen", this.isHen());
        tag.func_74757_a("Staring", this.isStaring());
        tag.func_74768_a("TamingLevel", this.getTamingLevel());
        tag.func_74768_a("TamingPlayer", ((Integer)this.field_70180_af.func_187225_a(TAMING_PLAYER)).intValue());
        tag.func_74768_a("Command", this.getCommand());
        tag.func_74757_a("HasHomePosition", this.hasHomePosition);
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(tag);
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setHen(tag.func_74767_n("Hen"));
        this.setStaring(tag.func_74767_n("Staring"));
        this.setTamingLevel(tag.func_74762_e("TamingLevel"));
        this.setTamingPlayer(tag.func_74762_e("TamingPlayer"));
        this.setCommand(tag.func_74762_e("Command"));
        this.hasHomePosition = tag.func_74767_n("HasHomePosition");
        if (this.hasHomePosition && tag.func_74762_e("HomeAreaX") != 0 && tag.func_74762_e("HomeAreaY") != 0 && tag.func_74762_e("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(tag, this.field_70170_p);
        }
    }

    public boolean func_233685_eM_() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            this.isSitting = isSitting = ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 1) != 0;
            return isSitting;
        }
        return this.isSitting;
    }

    public void func_233687_w_(boolean sitting) {
        super.func_204711_a(sitting);
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
    }

    public void fall(float distance, float damageMultiplier) {
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setHen(this.func_70681_au().nextBoolean());
        return spawnDataIn;
    }

    public boolean isHen() {
        return (Boolean)this.field_70180_af.func_187225_a(HEN);
    }

    public void setHen(boolean hen) {
        this.field_70180_af.func_187227_b(HEN, (Object)hen);
    }

    public int getTamingLevel() {
        return (Integer)this.field_70180_af.func_187225_a(TAMING_LEVEL);
    }

    public void setTamingLevel(int level) {
        this.field_70180_af.func_187227_b(TAMING_LEVEL, (Object)level);
    }

    public int getCommand() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    public void setCommand(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        this.func_233687_w_(command == 1);
    }

    public boolean isStaring() {
        if (this.field_70170_p.field_72995_K) {
            this.isStaring = (Boolean)this.field_70180_af.func_187225_a(STARING);
            return this.isStaring;
        }
        return this.isStaring;
    }

    public void setStaring(boolean staring) {
        this.field_70180_af.func_187227_b(STARING, (Object)staring);
        if (!this.field_70170_p.field_72995_K) {
            this.isStaring = staring;
        }
    }

    public void forcePreyToLook(MobEntity mob) {
        mob.func_70671_ap().func_75650_a(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_(), (float)mob.func_184649_cE(), (float)mob.func_70646_bf());
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean flag;
        boolean bl = flag = player.func_184586_b(hand).func_77973_b() == Items.field_151057_cb || player.func_184586_b(hand).func_77973_b() == Items.field_151058_ca;
        if (flag) {
            return super.func_230254_b_(player, hand);
        }
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151170_bI) {
            return super.func_230254_b_(player, hand);
        }
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (FoodUtils.isSeeds(player.func_184586_b(hand)) || player.func_184586_b(hand).func_77973_b() == Items.field_151078_bh) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(8.0f);
                    this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                    player.func_184586_b(hand).func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_184586_b(hand).func_190926_b()) {
                if (player.func_225608_bj_()) {
                    if (this.hasHomePosition) {
                        this.hasHomePosition = false;
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("cockatrice.command.remove_home"), true);
                        return ActionResultType.SUCCESS;
                    }
                    BlockPos pos = this.func_233580_cy_();
                    this.homePos = new HomePosition(pos, this.field_70170_p);
                    this.hasHomePosition = true;
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("cockatrice.command.new_home", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.homePos.getDimension()}), true);
                    return ActionResultType.SUCCESS;
                }
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() > 3) {
                    this.setCommand(0);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("cockatrice.command." + this.getCommand()), true);
                this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_70636_d() {
        boolean blindness;
        boolean sitting;
        double dist;
        super.func_70636_d();
        LivingEntity attackTarget = this.func_70638_az();
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && attackTarget instanceof PlayerEntity) {
            this.func_70624_b(null);
        }
        if (this.func_233685_eM_() && this.getCommand() != 1) {
            this.func_233687_w_(false);
        }
        if (this.func_233685_eM_() && attackTarget != null) {
            this.func_70624_b(null);
        }
        if (attackTarget != null && this.func_184191_r((Entity)attackTarget)) {
            this.func_70624_b(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (attackTarget == null || !attackTarget.func_70089_S()) {
                this.setTargetedEntity(0);
            } else if (this.isStaring() || this.shouldStareAttack((Entity)attackTarget)) {
                this.setTargetedEntity(attackTarget.func_145782_y());
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && attackTarget != null && this.getAnimationTick() == 7 && (dist = this.func_70068_e((Entity)attackTarget)) < 8.0) {
            attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
        }
        if (this.getAnimation() == ANIMATION_JUMPAT && attackTarget != null) {
            dist = this.func_70068_e((Entity)attackTarget);
            double d0 = attackTarget.func_226277_ct_() - this.func_226277_ct_();
            double d1 = attackTarget.func_226281_cx_() - this.func_226281_cx_();
            float leap = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            if (dist <= 16.0 && this.func_233570_aj_() && this.getAnimationTick() > 7 && this.getAnimationTick() < 12) {
                Vector3d Vector3d2 = this.func_213322_ci();
                Vector3d Vector3d1 = new Vector3d(attackTarget.func_226277_ct_() - this.func_226277_ct_(), 0.0, attackTarget.func_226281_cx_() - this.func_226281_cx_());
                if (Vector3d1.func_189985_c() > 1.0E-7) {
                    Vector3d1 = Vector3d1.func_72432_b().func_186678_a(0.4).func_178787_e(Vector3d2.func_186678_a(0.2));
                }
            }
            if (dist < 4.0 && this.getAnimationTick() > 10) {
                attackTarget.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
                if ((double)leap >= 1.0E-4) {
                    attackTarget.func_213317_d(attackTarget.func_213322_ci().func_72441_c(d0 / (double)leap * (double)0.8f + this.func_213322_ci().field_72450_a * (double)0.2f, 0.0, d1 / (double)leap * (double)0.8f + this.func_213322_ci().field_72449_c * (double)0.2f));
                }
            }
        }
        if ((sitting = this.func_233685_eM_()) && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
        boolean staring = this.isStaring();
        if (staring && this.stareProgress < 20.0f) {
            this.stareProgress += 0.5f;
        } else if (!staring && this.stareProgress > 0.0f) {
            this.stareProgress -= 0.5f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.ticksStaring = staring ? ++this.ticksStaring : 0;
        }
        if (!this.field_70170_p.field_72995_K && staring && (attackTarget == null || this.shouldMelee())) {
            this.setStaring(false);
        }
        if (attackTarget != null) {
            this.func_70671_ap().func_75650_a(attackTarget.func_226277_ct_(), attackTarget.func_226278_cu_() + (double)attackTarget.func_70047_e(), attackTarget.func_226281_cx_(), (float)this.func_184649_cE(), (float)this.func_70646_bf());
            if (!this.shouldMelee() && attackTarget instanceof MobEntity) {
                this.forcePreyToLook((MobEntity)attackTarget);
            }
        }
        boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || attackTarget != null && attackTarget.func_70644_a(Effects.field_76440_q);
        if (blindness) {
            this.setStaring(false);
        }
        if (!this.field_70170_p.field_72995_K && !blindness && attackTarget != null && EntityGorgon.isEntityLookingAt((LivingEntity)this, attackTarget, 0.6f) && EntityGorgon.isEntityLookingAt(attackTarget, (LivingEntity)this, 0.6f) && !EntityGorgon.isBlindfolded(attackTarget) && !this.shouldMelee()) {
            if (!this.isStaring()) {
                this.setStaring(true);
            } else {
                int attackStrength = this.getFriendsCount(attackTarget);
                if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    ++attackStrength;
                }
                attackTarget.func_195064_c(new EffectInstance(Effects.field_82731_v, 10, 2 + Math.min(1, attackStrength)));
                attackTarget.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, Math.min(4, attackStrength)));
                attackTarget.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
                if (attackStrength >= 2 && attackTarget.field_70173_aa % 40 == 0) {
                    attackTarget.func_70097_a(DamageSource.field_82727_n, (float)(attackStrength - 1));
                }
                attackTarget.func_70604_c((LivingEntity)this);
                if (!this.func_70909_n() && attackTarget instanceof PlayerEntity) {
                    this.setTamingPlayer(attackTarget.func_145782_y());
                    this.setTamingLevel(this.getTamingLevel() + 1);
                    if (this.getTamingLevel() % 100 == 0) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)46);
                    }
                    if (this.getTamingLevel() >= 1000) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                        if (this.getTamingPlayer() instanceof PlayerEntity) {
                            this.func_193101_c((PlayerEntity)this.getTamingPlayer());
                        }
                        this.func_70624_b(null);
                        this.setTamingPlayer(0);
                        this.setTargetedEntity(0);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && attackTarget == null && this.func_70681_au().nextInt(300) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_WATTLESHAKE);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shouldMelee() && !this.isMeleeMode) {
                this.switchAI(true);
            }
            if (!this.shouldMelee() && this.isMeleeMode) {
                this.switchAI(false);
            }
        }
        if (this.field_70170_p.field_72995_K && this.getTargetedEntity() != null && EntityGorgon.isEntityLookingAt((LivingEntity)this, this.getTargetedEntity(), 0.6f) && EntityGorgon.isEntityLookingAt(this.getTargetedEntity(), (LivingEntity)this, 0.6f) && this.isStaring() && this.hasTargetedEntity()) {
            LivingEntity livingEntity;
            if (this.clientSideAttackTime < this.getAttackDuration()) {
                ++this.clientSideAttackTime;
            }
            if ((livingEntity = this.getTargetedEntity()) != null) {
                this.func_70671_ap().func_75651_a((Entity)livingEntity, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = this.getAttackAnimationScale(0.0f);
                double d0 = livingEntity.func_226277_ct_() - this.func_226277_ct_();
                double d1 = livingEntity.func_226278_cu_() + (double)(livingEntity.func_213302_cg() * 0.5f) - (this.func_226278_cu_() + (double)this.func_70047_e());
                double d2 = livingEntity.func_226281_cx_() - this.func_226281_cx_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_70146_Z.nextDouble();
                while (d4 < d3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.func_226278_cu_() + d1 * d4 + (double)this.func_70047_e(), this.func_226281_cx_() + d2 * d4, 0.0, 0.0, 0.0);
                }
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private int getFriendsCount(LivingEntity attackTarget) {
        if (this.func_70638_az() == null) {
            return 0;
        }
        float dist = IafConfig.cockatriceChickenSearchLength;
        List list = this.field_70170_p.func_217357_a(EntityCockatrice.class, this.func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
        int i = 0;
        for (EntityCockatrice cockatrice : list) {
            boolean bothLooking;
            if (cockatrice.func_70028_i((Entity)this) || cockatrice.func_70638_az() == null || cockatrice.func_70638_az() != this.func_70638_az() || !(bothLooking = EntityGorgon.isEntityLookingAt((LivingEntity)cockatrice, cockatrice.func_70638_az(), 0.6f) && EntityGorgon.isEntityLookingAt(cockatrice.func_70638_az(), (LivingEntity)cockatrice, 0.6f))) continue;
            ++i;
        }
        return i;
    }

    public float getAttackAnimationScale(float f) {
        return ((float)this.clientSideAttackTime + f) / (float)this.getAttackDuration();
    }

    public boolean shouldStareAttack(Entity entity) {
        return this.func_70032_d(entity) > 5.0f;
    }

    public int getAttackDuration() {
        return 80;
    }

    private boolean shouldMelee() {
        boolean blindness;
        boolean bl = blindness = this.func_70644_a(Effects.field_76440_q) || this.func_70638_az() != null && this.func_70638_az().func_70644_a(Effects.field_76440_q);
        if (this.func_70638_az() != null) {
            return (double)this.func_70032_d((Entity)this.func_70638_az()) < 4.0 || ServerEvents.isCockatriceTarget((Entity)this.func_70638_az()) || blindness || !this.canUseStareOn((Entity)this.func_70638_az());
        }
        return false;
    }

    public void func_213352_e(Vector3d motionVec) {
        if (!this.canMove() && !this.func_184207_aI()) {
            motionVec = motionVec.func_216372_d(0.0, 1.0, 0.0);
        }
        super.func_213352_e(motionVec);
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_JUMPAT, ANIMATION_WATTLESHAKE, ANIMATION_BITE, ANIMATION_SPEAK, ANIMATION_EAT};
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return IafSoundRegistry.COCKATRICE_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return IafSoundRegistry.COCKATRICE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return IafSoundRegistry.COCKATRICE_DIE;
    }

    public void func_70103_a(byte id) {
        if (id == 45) {
            this.playEffect(true);
        } else if (id == 46) {
            this.playEffect(false);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect(boolean play) {
        BasicParticleType enumparticletypes = ParticleTypes.field_197633_z;
        if (!play) {
            enumparticletypes = ParticleTypes.field_197615_h;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)enumparticletypes, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

