/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.util;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.model.ModelRenderer;

public class EntityModelPartBuilder {
    private static final Map<String, Iterable<ModelRenderer>> PART_MAP = new HashMap<String, Iterable<ModelRenderer>>();
    private static final Map<String, Iterable<AdvancedModelBox>> ALL_PART_MAP = new HashMap<String, Iterable<AdvancedModelBox>>();

    private static Iterable<ModelRenderer> getPartsForRenderFromClass(Class clazz, String identifier) {
        Iterable<ModelRenderer> boxes = null;
        if (PART_MAP.get(identifier) == null) {
            ArrayList<ModelRenderer> rendererList = new ArrayList<ModelRenderer>();
            try {
                for (Field f : clazz.getDeclaredFields()) {
                    Object obj = f.get(null);
                    if (!(obj instanceof ModelRenderer)) continue;
                    rendererList.add((ModelRenderer)obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boxes = PART_MAP.put(identifier, (Iterable<ModelRenderer>)ImmutableList.copyOf(rendererList));
        } else {
            boxes = PART_MAP.get(identifier);
        }
        return boxes;
    }

    public static Iterable<AdvancedModelBox> getAllPartsFromClass(Class clazz, String identifier) {
        Iterable<AdvancedModelBox> boxes = null;
        if (ALL_PART_MAP.get(identifier) == null) {
            ArrayList<AdvancedModelBox> rendererList = new ArrayList<AdvancedModelBox>();
            try {
                for (Field f : clazz.getDeclaredFields()) {
                    Object obj = f.get(null);
                    if (!(obj instanceof AdvancedModelBox)) continue;
                    rendererList.add((AdvancedModelBox)obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ALL_PART_MAP.put(identifier, (Iterable<AdvancedModelBox>)ImmutableList.copyOf(rendererList));
        }
        boxes = ALL_PART_MAP.get(identifier);
        return boxes;
    }
}

