/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ITabulaModelAnimator;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumSeaSerpentAnimations;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import net.minecraft.client.Minecraft;

public class SeaSerpentTabulaModelAnimator
extends IceAndFireTabulaModelAnimator
implements ITabulaModelAnimator<EntitySeaSerpent> {
    public TabulaModel[] swimPose;

    public SeaSerpentTabulaModelAnimator() {
        super(EnumSeaSerpentAnimations.T_POSE.seaserpent_model);
        this.swimPose = new TabulaModel[]{EnumSeaSerpentAnimations.SWIM1.seaserpent_model, EnumSeaSerpentAnimations.SWIM3.seaserpent_model, EnumSeaSerpentAnimations.SWIM4.seaserpent_model, EnumSeaSerpentAnimations.SWIM6.seaserpent_model};
    }

    public void setRotationAngles(TabulaModel model, EntitySeaSerpent entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.resetToDefaultPose();
        model.getCube((String)"BodyUpper").field_78797_d += 9.0f;
        model.llibAnimator.update((IAnimatedEntity)entity);
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        int currentIndex = entity.swimCycle / 10;
        int prevIndex = currentIndex - 1;
        if (prevIndex < 0) {
            prevIndex = 3;
        }
        TabulaModel prevPosition = this.swimPose[prevIndex];
        TabulaModel currentPosition = this.swimPose[currentIndex];
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        float delta = (float)entity.swimCycle / 10.0f % 1.0f + partialTicks / 10.0f;
        AdvancedModelBox[] tailParts = new AdvancedModelBox[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4"), model.getCube("Tail5"), model.getCube("Tail6")};
        AdvancedModelBox[] neckParts = new AdvancedModelBox[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Head")};
        for (AdvancedModelBox cube : model.getCubes().values()) {
            if (entity.jumpProgress > 0.0f && !this.isRotationEqual(cube, EnumSeaSerpentAnimations.JUMPING2.seaserpent_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumSeaSerpentAnimations.JUMPING2.seaserpent_model.getCube(cube.boxName), entity.jumpProgress, 5.0f, false);
            }
            if (entity.wantJumpProgress > 0.0f && !this.isRotationEqual(cube, EnumSeaSerpentAnimations.JUMPING1.seaserpent_model.getCube(cube.boxName))) {
                this.transitionTo(cube, EnumSeaSerpentAnimations.JUMPING1.seaserpent_model.getCube(cube.boxName), entity.wantJumpProgress, 10.0f, false);
            }
            AdvancedModelBox prevPositionCube = prevPosition.getCube(cube.boxName);
            AdvancedModelBox currPositionCube = currentPosition.getCube(cube.boxName);
            float prevX = prevPositionCube.field_78795_f;
            float prevY = prevPositionCube.field_78796_g;
            float prevZ = prevPositionCube.field_78808_h;
            float x = currPositionCube.field_78795_f;
            float y = currPositionCube.field_78796_g;
            float z = currPositionCube.field_78808_h;
            this.addToRotateAngle(cube, limbSwingAmount, prevX + delta * this.distance(prevX, x), prevY + delta * this.distance(prevY, y), prevZ + delta * this.distance(prevZ, z));
        }
        if (entity.breathProgress > 0.0f) {
            this.progressRotation(model.getCube("Head"), entity.breathProgress, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
            this.progressRotation(model.getCube("HeadFront"), entity.breathProgress, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
            this.progressRotation(model.getCube("Jaw"), entity.breathProgress, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        }
        if (entity.jumpRot > 0.0f) {
            float jumpRot = entity.prevJumpRot + (entity.jumpRot - entity.prevJumpRot) * partialTicks;
            float turn = (float)entity.func_213322_ci().field_72448_b * -4.0f;
            model.getCube((String)"BodyUpper").field_78795_f += (float)Math.toRadians(22.5f * turn) * jumpRot;
            model.getCube((String)"Tail1").field_78795_f -= (float)Math.toRadians(turn) * jumpRot;
            model.getCube((String)"Tail2").field_78795_f -= (float)Math.toRadians(turn) * jumpRot;
            model.getCube((String)"Tail3").field_78795_f -= (float)Math.toRadians(turn) * jumpRot;
            model.getCube((String)"Tail4").field_78795_f -= (float)Math.toRadians(turn) * jumpRot;
        }
        float prevRenderOffset = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks;
        model.getCube((String)"Tail1").field_78796_g += (entity.getPieceYaw(1, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"Tail2").field_78796_g += (entity.getPieceYaw(2, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"Tail3").field_78796_g += (entity.getPieceYaw(3, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"Tail4").field_78796_g += (entity.getPieceYaw(4, partialTicks) - prevRenderOffset) * ((float)Math.PI / 180);
        model.getCube((String)"BodyUpper").field_78795_f -= rotationPitch * ((float)Math.PI / 180);
        if (!entity.isJumpingOutOfWater() || entity.func_70090_H()) {
            model.getCube((String)"Tail1").field_78795_f -= (entity.getPiecePitch(1, partialTicks) - 0.0f) * ((float)Math.PI / 180);
            model.getCube((String)"Tail2").field_78795_f -= (entity.getPiecePitch(2, partialTicks) - 0.0f) * ((float)Math.PI / 180);
            model.getCube((String)"Tail3").field_78795_f -= (entity.getPiecePitch(3, partialTicks) - 0.0f) * ((float)Math.PI / 180);
            model.getCube((String)"Tail4").field_78795_f -= (entity.getPiecePitch(4, partialTicks) - 0.0f) * ((float)Math.PI / 180);
        }
    }

    public void progressRotation(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.field_78795_f += progress * (rotX - model.defaultRotationX) / 20.0f;
        model.field_78796_g += progress * (rotY - model.defaultRotationY) / 20.0f;
        model.field_78808_h += progress * (rotZ - model.defaultRotationZ) / 20.0f;
    }

    private void animate(TabulaModel model, EntitySeaSerpent entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        if (model.llibAnimator.setAnimation(EntitySeaSerpent.ANIMATION_SPEAK)) {
            model.llibAnimator.startKeyframe(5);
            this.rotate(model.llibAnimator, model.getCube("Jaw"), 25.0f, 0.0f, 0.0f);
            model.llibAnimator.endKeyframe();
            model.llibAnimator.setStaticKeyframe(5);
            model.llibAnimator.resetKeyframe(5);
        }
        if (model.llibAnimator.setAnimation(EntitySeaSerpent.ANIMATION_BITE)) {
            model.llibAnimator.startKeyframe(5);
            this.moveToPose(model, EnumSeaSerpentAnimations.BITE1.seaserpent_model);
            model.llibAnimator.endKeyframe();
            model.llibAnimator.startKeyframe(5);
            this.moveToPose(model, EnumSeaSerpentAnimations.BITE2.seaserpent_model);
            model.llibAnimator.endKeyframe();
            model.llibAnimator.setStaticKeyframe(2);
            model.llibAnimator.resetKeyframe(3);
        }
        if (model.llibAnimator.setAnimation(EntitySeaSerpent.ANIMATION_ROAR)) {
            model.llibAnimator.startKeyframe(10);
            this.moveToPose(model, EnumSeaSerpentAnimations.ROAR1.seaserpent_model);
            model.llibAnimator.endKeyframe();
            model.llibAnimator.startKeyframe(10);
            this.moveToPose(model, EnumSeaSerpentAnimations.ROAR2.seaserpent_model);
            model.llibAnimator.endKeyframe();
            model.llibAnimator.startKeyframe(10);
            this.moveToPose(model, EnumSeaSerpentAnimations.ROAR3.seaserpent_model);
            model.llibAnimator.endKeyframe();
            model.llibAnimator.resetKeyframe(10);
        }
    }
}

