/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.gui.GuiMainMenuBlit;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.io.IOUtils;

public class IceAndFireMainMenu
extends MainMenuScreen {
    public static final int LAYER_COUNT = 2;
    public static final ResourceLocation splash = new ResourceLocation("iceandfire", "splashes.txt");
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURES = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation BESTIARY_TEXTURE = new ResourceLocation("iceandfire:textures/gui/main_menu/bestiary_menu.png");
    private static final ResourceLocation TABLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/main_menu/table.png");
    public static ResourceLocation[] pageFlipTextures;
    public static ResourceLocation[] drawingTextures;
    private int layerTick;
    private String splashText;
    private boolean isFlippingPage = false;
    private int pageFlip = 0;
    private Picture[] drawnPictures;
    private Enscription[] drawnEnscriptions;
    private float globalAlpha = 1.0f;

    public IceAndFireMainMenu() {
        pageFlipTextures = new ResourceLocation[]{new ResourceLocation("iceandfire", "textures/gui/main_menu/page_1.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_2.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_3.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_4.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_5.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_6.png")};
        for (int i = 0; i < drawingTextures.length; ++i) {
            IceAndFireMainMenu.drawingTextures[i] = new ResourceLocation("iceandfire", "textures/gui/main_menu/drawing_" + (i + 1) + ".png");
        }
        this.resetDrawnImages();
        String branch = "1.16.3";
        try (BufferedReader reader = IceAndFireMainMenu.getURLContents("https://raw.githubusercontent.com/Alex-the-666/Ice_and_Fire/1.16.3/src/main/resources/assets/iceandfire/splashes.txt", "assets/iceandfire/splashes.txt");){
            List list = IOUtils.readLines((Reader)reader);
            if (!list.isEmpty()) {
                do {
                    this.splashText = (String)list.get(ThreadLocalRandom.current().nextInt(list.size()));
                } while (this.splashText.hashCode() == 125780783);
            }
        }
        catch (IOException e) {
            IceAndFire.LOGGER.error("Exception trying to collect splash screen lines: ", (Throwable)e);
        }
    }

    public static BufferedReader getURLContents(String urlString, String backupFileLoc) {
        InputStream is;
        URL url;
        BufferedReader reader = null;
        boolean useBackup = false;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = null;
            useBackup = true;
        }
        if (url != null) {
            URLConnection connection = null;
            try {
                connection = url.openConnection();
                connection.setConnectTimeout(200);
                InputStream is2 = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is2));
            }
            catch (IOException e) {
                IceAndFire.LOGGER.warn("Ice and Fire couldn't download splash texts for main menu");
                useBackup = true;
            }
        }
        if (useBackup && (is = IceAndFireMainMenu.class.getClassLoader().getResourceAsStream(backupFileLoc)) != null) {
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return reader;
    }

    private void resetDrawnImages() {
        int x;
        int y;
        int i;
        this.globalAlpha = 0.0f;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.drawnPictures = new Picture[1 + ((Random)random).nextInt(2)];
        boolean left = ((Random)random).nextBoolean();
        for (i = 0; i < this.drawnPictures.length; ++i) {
            left = !left;
            y = ((Random)random).nextInt(25);
            x = left ? -15 - ((Random)random).nextInt(20) - 128 : 30 + ((Random)random).nextInt(20);
            this.drawnPictures[i] = new Picture(((Random)random).nextInt(drawingTextures.length - 1), x, y, 0.5f, ((Random)random).nextFloat() * 0.5f + 0.5f);
        }
        this.drawnEnscriptions = new Enscription[4 + ((Random)random).nextInt(8)];
        for (i = 0; i < this.drawnEnscriptions.length; ++i) {
            left = !left;
            y = 10 + ((Random)random).nextInt(130);
            x = left ? -30 - ((Random)random).nextInt(30) - 50 : 30 + ((Random)random).nextInt(30);
            String s1 = "missingno";
            this.drawnEnscriptions[i] = new Enscription(s1, x, y, ((Random)random).nextFloat() * 0.5f + 0.5f, 10259323);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        float flipTick = this.layerTick % 40;
        if (this.globalAlpha < 1.0f && !this.isFlippingPage && flipTick < 30.0f) {
            this.globalAlpha += 0.1f;
        }
        if (this.globalAlpha > 0.0f && flipTick > 30.0f) {
            this.globalAlpha -= 0.1f;
        }
        if (flipTick == 0.0f && !this.isFlippingPage) {
            this.isFlippingPage = true;
        }
        if (this.isFlippingPage) {
            if (this.layerTick % 2 == 0) {
                ++this.pageFlip;
            }
            if (this.pageFlip == 6) {
                this.pageFlip = 0;
                this.isFlippingPage = false;
                this.resetDrawnImages();
            }
        }
        ++this.layerTick;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        int i;
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.getMinecraft().func_110434_K().func_110577_a(TABLE_TEXTURE);
        int width = this.field_230708_k_;
        int height = this.field_230709_l_;
        IceAndFireMainMenu.func_238463_a_((MatrixStack)ms, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
        this.getMinecraft().func_110434_K().func_110577_a(BESTIARY_TEXTURE);
        IceAndFireMainMenu.func_238463_a_((MatrixStack)ms, (int)50, (int)0, (float)0.0f, (float)0.0f, (int)(width - 100), (int)height, (int)(width - 100), (int)height);
        if (this.isFlippingPage) {
            this.getMinecraft().func_110434_K().func_110577_a(pageFlipTextures[Math.min(5, this.pageFlip)]);
            IceAndFireMainMenu.func_238463_a_((MatrixStack)ms, (int)50, (int)0, (float)0.0f, (float)0.0f, (int)(width - 100), (int)height, (int)(width - 100), (int)height);
        } else {
            int middleX = width / 2;
            int middleY = height / 5;
            float widthScale = (float)width / 427.0f;
            float heightScale = (float)height / 427.0f;
            float imageScale = Math.min(widthScale, heightScale) * 192.0f;
            for (Picture picture : this.drawnPictures) {
                float alpha = picture.alpha * this.globalAlpha + 0.01f;
                RenderSystem.enableBlend();
                this.getMinecraft().func_110434_K().func_110577_a(drawingTextures[picture.image]);
                GuiMainMenuBlit.blit((int)((float)picture.x * widthScale + (float)middleX), (int)((float)picture.y * heightScale + (float)middleY), 0.0f, 0.0f, (int)imageScale, (int)imageScale, (int)imageScale, (int)imageScale, alpha);
            }
        }
        GlStateManager.func_227619_H_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227740_m_();
        this.getMinecraft().field_71466_p.func_238421_b_(ms, "Ice and Fire " + TextFormatting.YELLOW + IceAndFire.VERSION, 2.0f, (float)(height - 10), -1);
        GlStateManager.func_227626_N_();
        this.getMinecraft().func_110434_K().func_110577_a(MINECRAFT_TITLE_TEXTURES);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(ms, width / 2 - 137, 10, 0, 0, 155, 44);
        this.func_238474_b_(ms, width / 2 - 137 + 155, 10, 0, 45, 155, 44);
        GlStateManager.func_227688_c_((float)(width / 2 + 100), (float)85.0f, (float)0.0f);
        GlStateManager.func_227689_c_((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
        f1 = f1 * 100.0f / (float)(this.getMinecraft().field_71466_p.func_78256_a(this.splashText) + 32);
        RenderSystem.translatef((float)0.0f, (float)(f1 * 10.0f), (float)0.0f);
        RenderSystem.scalef((float)f1, (float)f1, (float)f1);
        IceAndFireMainMenu.func_238471_a_((MatrixStack)ms, (FontRenderer)this.getMinecraft().field_71466_p, (String)this.splashText, (int)0, (int)-40, (int)TextFormatting.YELLOW.func_211163_e());
        GlStateManager.func_227627_O_();
        ForgeHooksClient.renderMainMenu((MainMenuScreen)this, (MatrixStack)ms, (FontRenderer)this.getMinecraft().field_71466_p, (int)width, (int)height);
        String s1 = "Copyright Mojang AB. Do not distribute!";
        FontRenderer font = this.getMinecraft().field_71466_p;
        AbstractGui.func_238476_c_((MatrixStack)ms, (FontRenderer)font, (String)s1, (int)(width - this.getMinecraft().field_71466_p.func_78256_a(s1) - 2), (int)(height - 10), (int)-1);
        for (i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(ms, mouseX, mouseY, partialTicks);
        }
        for (i = 0; i < this.field_230710_m_.size(); ++i) {
            ((Widget)this.field_230710_m_.get(i)).func_230430_a_(ms, mouseX, mouseY, this.getMinecraft().func_184121_ak());
        }
    }

    static {
        drawingTextures = new ResourceLocation[22];
    }

    private class Enscription {
        public Enscription(String text, int x, int y, float alpha, int color) {
        }
    }

    private class Picture {
        int image;
        int x;
        int y;
        float alpha;

        public Picture(int image, int x, int y, float alpha, float scale) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

